/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ReleaseVersion {
    public static final void releaseVersion(File changesFile, String currentVersion, String version, String encoding) throws DocumentException, FileNotFoundException, UnsupportedEncodingException, IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ReleaseVersion.releaseVersion(changesFile, currentVersion, version, encoding, dateFormat.format(new Date()));
    }

    static final Document transformVersion(File changesFile, String currentVersion, String version, String date) throws DocumentException, FileNotFoundException, UnsupportedEncodingException, IOException {
        SAXReader r = new SAXReader();
        Document doc = r.read(changesFile);
        Element root = doc.getRootElement();
        Element releases = root.element("body");
        Iterator i = releases.elementIterator("release");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            Attribute v = e.attribute("version");
            if (v == null) continue;
            String text = v.getText();
            Attribute d = e.attribute("date");
            boolean updateRelease = false;
            if (text.equals(currentVersion) || text.equals(version)) {
                updateRelease = true;
            }
            if (updateRelease && d != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    dateFormat.parse(d.getText());
                    updateRelease = false;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
            if (!updateRelease) continue;
            v.setText(version);
            if (d == null) {
                e.addAttribute("date", date);
            } else {
                d.setText(date);
            }
            return doc;
        }
        return null;
    }

    public static final void releaseVersion(File changesFile, String currentVersion, String version, String encoding, String date) throws DocumentException, FileNotFoundException, UnsupportedEncodingException, IOException {
        Document doc = ReleaseVersion.transformVersion(changesFile, currentVersion, version, date);
        if (doc == null) {
            return;
        }
        FileUtils.copyFile((File)changesFile, (File)new File(changesFile + ".backup"));
        FileOutputStream os = new FileOutputStream(changesFile);
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        format.setPadText(true);
        if (encoding == null || "".equals(encoding)) {
            String docsEncoding = doc.getXMLEncoding();
            if (docsEncoding != null) {
                format.setEncoding(docsEncoding);
            }
        } else {
            format.setEncoding(encoding);
        }
        XMLWriter writer = new XMLWriter(format);
        writer.setOutputStream((OutputStream)os);
        writer.write(doc);
        writer.flush();
        writer.close();
    }
}

