/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.werkz;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.NoActionDefinitionException;
import org.apache.maven.werkz.NoSuchGoalException;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.UnattainableGoalException;

public class WerkzProject {
    private Map goals = new HashMap();
    private String defaultGoalName;

    public Goal[] getExecutionChain(String name) throws NoSuchGoalException {
        Goal goal = this.getGoal(name);
        LinkedList<Goal> chain = new LinkedList<Goal>();
        LinkedList<Goal> stack = new LinkedList<Goal>();
        stack.addLast(goal);
        while (!stack.isEmpty()) {
            goal = (Goal)stack.removeFirst();
            if (chain.contains(goal)) continue;
            chain.addFirst(goal);
            List precursors = goal.getPrecursors();
            Iterator precursorIter = precursors.iterator();
            while (precursorIter.hasNext()) {
                Goal eachPrecursor = (Goal)precursorIter.next();
                if (chain.contains(eachPrecursor)) continue;
                stack.addLast(eachPrecursor);
            }
        }
        return chain.toArray(Goal.EMPTY_ARRAY);
    }

    public void attainGoal(String name, Session session) throws NoSuchGoalException, UnattainableGoalException, NoActionDefinitionException {
        Goal goal = this.getGoal(name);
        if (goal == null) {
            throw new NoSuchGoalException(name);
        }
        goal.attain(session);
    }

    public void percolateGoal(String name, Session session) throws NoSuchGoalException, UnattainableGoalException, NoActionDefinitionException {
        Goal goal = this.getGoal(name);
        if (goal == null) {
            throw new NoSuchGoalException(name);
        }
        goal.percolate(session);
    }

    public void attainGoal(String name) throws NoSuchGoalException, UnattainableGoalException, NoActionDefinitionException {
        this.attainGoal(name, new Session());
    }

    public void percolateGoal(String name) throws NoSuchGoalException, UnattainableGoalException, NoActionDefinitionException {
        this.percolateGoal(name, new Session());
    }

    public void addGoal(Goal goal) {
        this.goals.put(goal.getName(), goal);
    }

    public Goal getGoal(String name) {
        return (Goal)this.goals.get(name);
    }

    public Goal getGoal(String name, boolean create) {
        Goal goal = this.getGoal(name);
        if (goal == null && create) {
            goal = new Goal(name);
            this.addGoal(goal);
        }
        return goal;
    }

    public void setDefaultGoalName(String defaultGoalName) {
        this.defaultGoalName = defaultGoalName;
    }

    public String getDefaultGoalName() {
        return this.defaultGoalName;
    }

    public Goal getDefaultGoal() {
        return this.getGoal(this.getDefaultGoalName());
    }

    public Collection getGoals() {
        return Collections.unmodifiableCollection(this.goals.values());
    }

    public String toString() {
        return "[Werkz: goals=" + this.goals + ";]";
    }

    public void removeGoal(String name) {
        this.goals.remove(name);
    }
}

