/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.verifier;

import java.io.File;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.project.Project;
import org.apache.maven.verifier.RepoConfigException;

public class LocalSettingsVerifier
extends AbstractMavenComponent {
    public LocalSettingsVerifier(Project project) {
        super(project);
    }

    public void verifyLocalRepository() throws RepoConfigException {
        String localRepoProp = this.getProject().getContext().getMavenRepoLocal();
        if (localRepoProp == null) {
            throw new RepoConfigException(this.getMessage("maven.repo.local.unset"));
        }
        File localRepo = new File(localRepoProp);
        if (!localRepo.exists()) {
            System.err.println(this.getMessage("directory.nonexistant.warning", localRepo));
            if (!localRepo.mkdirs()) {
                throw new RepoConfigException(this.getMessage("cannot.create.directory.warning", localRepo));
            }
        }
        if (!localRepo.isDirectory()) {
            throw new RepoConfigException(this.getMessage("not.directory.warning", localRepo));
        }
        if (!localRepo.canWrite()) {
            throw new RepoConfigException(this.getMessage("not.writable.warning", localRepo));
        }
    }
}

