/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.verifier;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.Project;
import org.apache.maven.repository.Artifact;
import org.apache.maven.util.BootstrapDownloadMeter;
import org.apache.maven.util.ConsoleDownloadMeter;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.LocalSettingsVerifier;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DependencyVerifier
extends AbstractMavenComponent {
    private static final Log LOGGER = LogFactory.getLog((Class)DependencyVerifier.class);
    private List failedDependencies = new ArrayList();
    private LocalSettingsVerifier localRepositoryVerifier;
    private static Set resolvedArtifacts = new HashSet();
    private ProxyInfo proxyInfo = null;
    private TransferListener listener = null;
    static /* synthetic */ Class class$org$apache$maven$wagon$providers$http$HttpWagon;
    static /* synthetic */ Class class$org$apache$maven$wagon$providers$ssh$jsch$SftpWagon;
    static /* synthetic */ Class class$org$apache$maven$wagon$providers$file$FileWagon;

    public DependencyVerifier(Project project) {
        super(project);
        String meterType;
        this.localRepositoryVerifier = new LocalSettingsVerifier(project);
        MavenJellyContext context = this.getProject().getContext();
        if (context.getProxyHost() != null) {
            this.proxyInfo = new ProxyInfo();
            this.proxyInfo.setHost(context.getProxyHost());
            try {
                this.proxyInfo.setPort(Integer.valueOf(context.getProxyPort()).intValue());
            }
            catch (NumberFormatException e) {
                LOGGER.warn((Object)("Ignoring invalid proxy port: '" + context.getProxyPort() + "'"));
            }
            this.proxyInfo.setUserName(context.getProxyUserName());
            this.proxyInfo.setPassword(context.getProxyPassword());
            this.proxyInfo.setNonProxyHosts((String)context.getVariable("maven.proxy.nonProxyHosts"));
            this.proxyInfo.setNtlmHost((String)context.getVariable("maven.proxy.ntlm.host"));
            this.proxyInfo.setNtlmDomain((String)context.getVariable("maven.proxy.ntlm.domain"));
        }
        if ((meterType = (String)context.getVariable("maven.download.meter")) == null) {
            meterType = "console";
        }
        if ("bootstrap".equals(meterType)) {
            this.listener = new BootstrapDownloadMeter();
        } else if ("console".equals(meterType)) {
            this.listener = new ConsoleDownloadMeter();
        }
    }

    public void verify() throws RepoConfigException, UnsatisfiedDependencyException, ChecksumVerificationException {
        this.localRepositoryVerifier.verifyLocalRepository();
        this.satisfyDependencies();
    }

    private void clearFailedDependencies() {
        this.failedDependencies.clear();
    }

    private void satisfyDependencies() throws UnsatisfiedDependencyException, ChecksumVerificationException {
        boolean remoteRepoEnabled = this.getProject().getContext().getRemoteRepositoryEnabled();
        boolean online = this.getProject().getContext().getOnline();
        if (!remoteRepoEnabled) {
            LOGGER.warn((Object)this.getMessage("remote.repository.disabled.warning"));
        }
        this.clearFailedDependencies();
        Iterator i = this.getProject().getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String path = artifact.getUrlPath();
            if (resolvedArtifacts.contains(path)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("(previously resolved: " + path + ")"));
                continue;
            }
            resolvedArtifacts.add(path);
            if (!artifact.exists()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Artifact [" + path + "] not found in local repository"));
                }
                this.failedDependencies.add(artifact);
                continue;
            }
            if (!artifact.isSnapshot() || "path".equals(artifact.getOverrideType())) continue;
            if (online) {
                this.failedDependencies.add(artifact);
                continue;
            }
            LOGGER.warn((Object)this.getMessage("offline.snapshot.warning", artifact.getName()));
        }
        if (!this.failedDependencies.isEmpty() && remoteRepoEnabled && online) {
            this.getDependencies();
        }
        if (!this.failedDependencies.isEmpty()) {
            throw new UnsatisfiedDependencyException(this.createUnsatisfiedDependenciesMessage());
        }
    }

    private String createUnsatisfiedDependenciesMessage() {
        StringBuffer message = new StringBuffer();
        if (this.failedDependencies.size() == 1) {
            message.append(this.getMessage("single.unsatisfied.dependency.error"));
        } else {
            message.append(this.getMessage("multiple.unsatisfied.dependency.error"));
        }
        message.append("\n");
        Iterator i = this.failedDependencies.iterator();
        while (i.hasNext()) {
            String url;
            Artifact artifact = (Artifact)i.next();
            message.append("- " + artifact.getDescription());
            String overrideType = artifact.getOverrideType();
            if (overrideType != Artifact.OVERRIDE_NONE) {
                if ("version".equals(overrideType)) {
                    message.append("; version override doesn't exist: " + artifact.getDependency().getVersion());
                } else if ("path".equals(overrideType)) {
                    message.append("; path override doesn't exist: " + artifact.getPath());
                }
            }
            if (StringUtils.isNotEmpty((String)(url = artifact.getDependency().getUrl()))) {
                message.append(" (").append("try downloading from ").append(url).append(")");
            }
            message.append("\n");
        }
        return message.toString();
    }

    private void getDependencies() throws ChecksumVerificationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Getting failed dependencies: " + this.failedDependencies));
        }
        if (this.failedDependencies.size() > 0) {
            LOGGER.info((Object)this.getMessage("satisfy.project.message", this.getProject().getName()));
        }
        Iterator i = this.failedDependencies.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String overrideType = artifact.getOverrideType();
            if ("path".equals(overrideType)) continue;
            File directory = artifact.getFile().getParentFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (this.getRemoteArtifact(artifact)) {
                i.remove();
                continue;
            }
            if (!artifact.exists()) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRemoteArtifact(Artifact artifact) throws ChecksumVerificationException {
        boolean artifactFound = false;
        int count = 0;
        Iterator i = this.getProject().getContext().getMavenRepoRemote().iterator();
        while (i.hasNext()) {
            String remoteRepo = (String)i.next();
            if (artifact.isSnapshot() && artifact.exists()) {
                LOGGER.info((Object)(this.getMessage("update.message") + " " + artifact.getDescription() + " from " + remoteRepo));
            } else {
                LOGGER.info((Object)(this.getMessage("download.message") + " " + artifact.getDescription() + " from " + remoteRepo));
            }
            Repository repository = new Repository("repo" + count++, remoteRepo.trim());
            Wagon wagon = new DefaultWagonFactory().getWagon(repository.getProtocol());
            if (this.listener != null) {
                wagon.addTransferListener(this.listener);
            }
            ChecksumObserver md5ChecksumObserver = null;
            ChecksumObserver sha1ChecksumObserver = null;
            try {
                md5ChecksumObserver = new ChecksumObserver("MD5");
                wagon.addTransferListener((TransferListener)md5ChecksumObserver);
                sha1ChecksumObserver = new ChecksumObserver("SHA-1");
                wagon.addTransferListener((TransferListener)sha1ChecksumObserver);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ChecksumVerificationException("Unable to add checksum methods: " + e.getMessage(), e);
            }
            File destination = artifact.getFile();
            String remotePath = artifact.getUrlPath();
            File temp = new File(destination + ".tmp");
            temp.deleteOnExit();
            boolean downloaded = false;
            try {
                wagon.connect(repository, this.proxyInfo);
                boolean firstRun = true;
                boolean retry = true;
                while (firstRun || retry) {
                    block39: {
                        retry = false;
                        downloaded = wagon.getIfNewer(remotePath, temp, destination.lastModified());
                        if (!downloaded && firstRun) {
                            LOGGER.info((Object)this.getMessage("skip.download.message"));
                        }
                        if (downloaded) {
                            if (this.listener != null) {
                                wagon.removeTransferListener(this.listener);
                            }
                            try {
                                this.verifyChecksum(md5ChecksumObserver, destination, temp, remotePath, ".md5", wagon);
                            }
                            catch (ChecksumVerificationException e) {
                                if (firstRun) {
                                    LOGGER.warn((Object)("*** CHECKSUM FAILED - " + e.getMessage() + " - RETRYING"));
                                    retry = true;
                                }
                                throw new ChecksumVerificationException(e.getMessage(), e.getCause());
                            }
                            catch (ResourceDoesNotExistException md5TryException) {
                                LOGGER.debug((Object)"MD5 not found, trying SHA1", (Throwable)md5TryException);
                                try {
                                    this.verifyChecksum(sha1ChecksumObserver, destination, temp, remotePath, ".sha1", wagon);
                                }
                                catch (ChecksumVerificationException e) {
                                    if (firstRun) {
                                        retry = true;
                                        break block39;
                                    }
                                    throw new ChecksumVerificationException(e.getMessage(), e.getCause());
                                }
                                catch (ResourceDoesNotExistException sha1TryException) {
                                    throw new ChecksumVerificationException("Error retrieving checksum file for " + remotePath, sha1TryException);
                                }
                            }
                        }
                    }
                    artifactFound = true;
                    if (!artifact.isSnapshot()) {
                        break;
                    }
                    if (this.listener != null) {
                        wagon.addTransferListener(this.listener);
                    }
                    firstRun = false;
                }
            }
            catch (ResourceDoesNotExistException e) {
                LOGGER.debug((Object)"File not found on one of the repos", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error retrieving artifact from [" + repository.getUrl() + "]: " + e));
                LOGGER.debug((Object)"Error details", (Throwable)e);
            }
            finally {
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    LOGGER.debug((Object)"Error disconnecting wagon", (Throwable)e);
                }
            }
            if (!temp.exists() && downloaded) {
                LOGGER.debug((Object)("Downloaded file does not exist: " + temp));
                artifactFound = false;
            }
            if (!temp.renameTo(destination) && downloaded) {
                try {
                    FileUtils.copyFile((File)temp, (File)destination);
                    temp.delete();
                }
                catch (IOException e) {
                    LOGGER.debug((Object)("Error copying temporary file to the final destination: " + e.getMessage()));
                    artifactFound = false;
                }
            }
            if (!artifactFound) continue;
            break;
        }
        return artifactFound;
    }

    private void verifyChecksum(ChecksumObserver checksumObserver, File destination, File tempDestination, String remotePath, String checksumFileExtension, Wagon wagon) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException, ChecksumVerificationException {
        try {
            File checksumFile;
            String actualChecksum = checksumObserver.getActualChecksum();
            File tempChecksumFile = new File(tempDestination + checksumFileExtension + ".tmp");
            tempChecksumFile.deleteOnExit();
            wagon.get(remotePath + checksumFileExtension, tempChecksumFile);
            String expectedChecksum = FileUtils.fileRead((File)tempChecksumFile);
            expectedChecksum = expectedChecksum.trim();
            if (expectedChecksum.startsWith("MD5")) {
                int lastSpacePos = expectedChecksum.lastIndexOf(32);
                expectedChecksum = expectedChecksum.substring(lastSpacePos + 1);
            } else {
                int spacePos = expectedChecksum.indexOf(32);
                if (spacePos != -1) {
                    expectedChecksum = expectedChecksum.substring(0, spacePos);
                }
            }
            if (expectedChecksum.equals(actualChecksum)) {
                checksumFile = new File(destination + checksumFileExtension);
                if (checksumFile.exists()) {
                    checksumFile.delete();
                }
            } else {
                throw new ChecksumVerificationException("Checksum failed on download: local = '" + actualChecksum + "'; remote = '" + expectedChecksum + "'");
            }
            FileUtils.copyFile((File)tempChecksumFile, (File)checksumFile);
        }
        catch (IOException e) {
            throw new ChecksumVerificationException("Invalid checksum file", e);
        }
    }

    private static class DefaultWagonFactory {
        private final Map map = new HashMap();

        public DefaultWagonFactory() {
            this.map.put("http", class$org$apache$maven$wagon$providers$http$HttpWagon == null ? (class$org$apache$maven$wagon$providers$http$HttpWagon = DependencyVerifier.class$("org.apache.maven.wagon.providers.http.HttpWagon")) : class$org$apache$maven$wagon$providers$http$HttpWagon);
            this.map.put("https", class$org$apache$maven$wagon$providers$http$HttpWagon == null ? (class$org$apache$maven$wagon$providers$http$HttpWagon = DependencyVerifier.class$("org.apache.maven.wagon.providers.http.HttpWagon")) : class$org$apache$maven$wagon$providers$http$HttpWagon);
            this.map.put("sftp", class$org$apache$maven$wagon$providers$ssh$jsch$SftpWagon == null ? (class$org$apache$maven$wagon$providers$ssh$jsch$SftpWagon = DependencyVerifier.class$("org.apache.maven.wagon.providers.ssh.jsch.SftpWagon")) : class$org$apache$maven$wagon$providers$ssh$jsch$SftpWagon);
            this.map.put("file", class$org$apache$maven$wagon$providers$file$FileWagon == null ? (class$org$apache$maven$wagon$providers$file$FileWagon = DependencyVerifier.class$("org.apache.maven.wagon.providers.file.FileWagon")) : class$org$apache$maven$wagon$providers$file$FileWagon);
        }

        public final Wagon getWagon(String protocol) {
            Wagon ret;
            Class aClass = (Class)this.map.get(protocol);
            if (aClass == null) {
                LOGGER.info((Object)("Unknown protocol: `" + protocol + "'. Trying file wagon"));
                ret = new FileWagon();
            } else {
                try {
                    ret = (Wagon)aClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }
    }
}

