/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class MD5Sum {
    private File file;
    private String checksum;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
        }
        return new String(buffer);
    }

    public byte[] getBytes(File file) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream stream = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)stream).read(buf, 0, 1024)) != -1) {
            baos.write(buf, 0, len);
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void execute() throws Exception {
        if (!this.file.exists()) {
            System.err.println("Specified file " + this.file + " doesn't exist.");
        }
        MessageDigest md5Helper = MessageDigest.getInstance("MD5");
        this.setChecksum(this.encode(md5Helper.digest(this.getBytes(this.file))));
    }
}

