/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

public class BootstrapDownloadMeter
implements TransferListener {
    private static final Log LOGGER = LogFactory.getLog((Class)BootstrapDownloadMeter.class);
    private int shownSoFar = 0;
    private final int numHashes;
    private final char hashChar;
    private long complete = 0L;

    public BootstrapDownloadMeter() {
        this(20, '.');
    }

    public BootstrapDownloadMeter(int numHashes, char hashChar) {
        this.numHashes = numHashes;
        this.hashChar = hashChar;
    }

    public void transferInitiated(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
        this.shownSoFar = 0;
        this.complete = 0L;
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        long total = transferEvent.getResource().getContentLength();
        this.complete += (long)length;
        if (total > 0L) {
            int numToShow = (int)(this.complete * (long)this.numHashes / total);
            for (int i = this.shownSoFar + 1; i <= numToShow; ++i) {
                System.out.print(this.hashChar);
            }
            this.shownSoFar = numToShow;
        }
    }

    public void transferCompleted(TransferEvent transferEvent) {
        long total = transferEvent.getResource().getContentLength();
        System.out.println(" (" + total / 1024L + "K)");
    }

    public void transferError(TransferEvent transferEvent) {
        LOGGER.error((Object)transferEvent.getException().getMessage());
    }

    public void debug(String message) {
        LOGGER.debug((Object)message);
    }
}

