/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository;

import org.apache.maven.project.Project;
import org.apache.maven.repository.ArtifactTypeHandler;

public class DefaultArtifactTypeHandler
implements ArtifactTypeHandler {
    public String constructRepositoryDirectoryPath(String type, Project project) {
        StringBuffer path = new StringBuffer();
        path.append(project.getArtifactDirectory());
        path.append("/");
        path.append(type + "s");
        path.append("/");
        return path.toString();
    }

    public String constructRepositoryFullPath(String type, Project project, String version) {
        StringBuffer path = new StringBuffer(this.constructRepositoryDirectoryPath(type, project));
        path.append(project.getArtifactId());
        path.append("-");
        path.append(version);
        path.append(this.extensionForType(type));
        return path.toString();
    }

    private String extensionForType(String type) {
        if ("uberjar".equals(type) || "ejb".equals(type) || "plugin".equals(type)) {
            return ".jar";
        }
        return "." + type;
    }
}

