/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.ArtifactListBuilder;
import org.apache.maven.DependencyClasspathBuilder;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Model;
import org.apache.maven.project.Organization;
import org.apache.maven.project.PackageGroup;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.apache.maven.project.io.stax.MavenStaxReader;
import org.apache.maven.project.io.stax.MavenStaxWriter;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.DependencyVerifier;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;

public class Project {
    private static final Log LOGGER = LogFactory.getLog((Class)Project.class);
    private HashMap versionMap;
    private Project parent;
    private File file;
    private Map dependencyPaths = new HashMap();
    private Map dependencyMap = new HashMap();
    private List artifactList;
    private MavenJellyContext context;
    private List contextStack = new ArrayList();
    private File mavenXml;
    private final Model model;
    private String originalGroupId;
    private boolean initialized = false;
    private DependencyVerifier dependencyVerifier;
    private String dependencyClasspath;

    public Project() {
        this.model = new Model();
    }

    public Project(Reader in) throws Exception {
        MavenStaxReader reader = new MavenStaxReader();
        this.model = reader.read(in);
        this.resolveDependencies();
        this.resolveVersions();
    }

    public Project(URL url) throws Exception {
        MavenStaxReader reader = new MavenStaxReader();
        this.model = reader.read(url.getFile());
        this.resolveDependencies();
        this.resolveVersions();
    }

    public Project(String path) throws Exception {
        MavenStaxReader reader = new MavenStaxReader();
        this.model = reader.read(path);
        this.resolveDependencies();
        this.resolveVersions();
    }

    public File getMavenXml() {
        if (this.mavenXml == null && this.getFile() != null) {
            this.mavenXml = new File(this.getFile().getParentFile(), "maven.xml");
        }
        return this.mavenXml;
    }

    public boolean hasMavenXml() {
        File mavenXml = this.getMavenXml();
        if (mavenXml != null) {
            return mavenXml.exists();
        }
        return false;
    }

    public String getId() {
        if (this.model.getId() != null && this.model.getId().indexOf(":") > 0) {
            return this.model.getId();
        }
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public void setId(String id) {
        int i = id.indexOf("+");
        int j = id.indexOf(":");
        if (i > 0) {
            this.setGroupId(id.substring(0, i));
            this.setArtifactId(id.replace('+', '-'));
        } else if (j > 0) {
            this.setGroupId(id.substring(0, j));
            this.setArtifactId(id.substring(j + 1));
        } else {
            this.setGroupId(id);
            this.setArtifactId(id);
        }
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public MavenJellyContext getPluginContext(String pluginId) throws Exception {
        PluginManager pluginManager = this.context.getMavenSession().getPluginManager();
        return pluginManager.getPluginContext(pluginId);
    }

    public void setContext(MavenJellyContext context) {
        if (this.contextStack.size() > 0) {
            LOGGER.warn((Object)"replacing a context when the stack is not empty");
        }
        this.context = context;
    }

    public void pushContext(MavenJellyContext context) {
        LOGGER.debug((Object)("pushing on " + (Object)((Object)context) + " over " + (Object)((Object)this.context) + " in " + this.getId()));
        this.contextStack.add(this.context);
        this.context = context;
    }

    public void popContext() {
        MavenJellyContext context = (MavenJellyContext)((Object)this.contextStack.get(this.contextStack.size() - 1));
        this.contextStack.remove(this.contextStack.size() - 1);
        LOGGER.debug((Object)("popping off " + (Object)((Object)this.context) + " for " + (Object)((Object)context) + " in " + this.getId()));
        this.context = context;
    }

    public MavenJellyContext getContext() {
        return this.context;
    }

    public void setArtifacts(List artifactList) {
        this.artifactList = artifactList;
    }

    public List getArtifacts() {
        return this.artifactList;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public Project getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    public File parentBasedir() {
        return new File(this.getExtend()).getParentFile();
    }

    public File parentMavenXml() {
        return new File(this.parentBasedir(), "maven.xml");
    }

    public String getArtifactDirectory() {
        if (this.getGroupId() != null) {
            return this.getGroupId();
        }
        return Project.standardToLegacyId(this.getId());
    }

    public void addDependency(Dependency dependency) {
        if (!this.getDependencies().contains(dependency)) {
            this.model.addDependency(dependency);
            this.dependencyMap.put(dependency.getKey(), dependency);
        }
    }

    static void mergeLists(List srcList, List targetList) {
        if (srcList != null) {
            Iterator i = srcList.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (targetList.contains(o)) continue;
                targetList.add(o);
            }
        }
    }

    private void addParentDependencies(List dependencies) {
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            this.addDependency((Dependency)i.next());
        }
    }

    public Set getDependentProjectIds() {
        TreeSet<String> projectIds = new TreeSet<String>();
        List dependencies = this.getDependencies();
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency dependency = (Dependency)dependencies.get(i);
            projectIds.add(dependency.getId());
        }
        return projectIds;
    }

    public void setDependencyPath(String depId, String path) {
        this.dependencyPaths.put(depId, path);
    }

    public String getDependencyPath(String depId) {
        return (String)this.dependencyPaths.get(this.legacyToDependencyKey(depId));
    }

    public Dependency getDependency(String depId) {
        return (Dependency)this.dependencyMap.get(this.legacyToDependencyKey(depId));
    }

    public boolean hasRepository() {
        return this.getRepository() != null;
    }

    public boolean isPomCurrent() {
        return Integer.parseInt(this.getPomVersion()) == 3;
    }

    public Version getVersionById(String versionId) {
        return (Version)this.versionMap.get(versionId);
    }

    public void initialize() throws IOException {
        if (this.initialized) {
            return;
        }
        this.buildArtifactList();
        this.dependencyClasspath = DependencyClasspathBuilder.build(this);
        this.setDependencyVerifier(new DependencyVerifier(this));
        if (this.getBuild() != null) {
            Project.resolveDirectories(this.getBuild(), this.file.getParentFile());
        }
        this.initialized = true;
    }

    public void verifyDependencies() throws RepoConfigException, UnsatisfiedDependencyException, ChecksumVerificationException {
        LOGGER.debug((Object)("Verifying dependencies for " + this.getId()));
        if (this.getFile() != null && this.getFile().exists() && this.initialized) {
            this.getDependencyVerifier().verify();
        }
    }

    public void setDependencyVerifier(DependencyVerifier dependencyVerifier) {
        this.dependencyVerifier = dependencyVerifier;
    }

    public DependencyVerifier getDependencyVerifier() {
        return this.dependencyVerifier;
    }

    public String getDependencyClasspath() {
        return this.dependencyClasspath;
    }

    public void buildArtifactList() {
        this.artifactList = ArtifactListBuilder.build(this);
    }

    public static String legacyToStandardId(String id) {
        String newId = id;
        if (id.indexOf("+") != -1) {
            int plusPos = id.indexOf("+");
            String groupId = id.substring(0, plusPos);
            String partialArtifactId = id.substring(plusPos + 1);
            newId = groupId + ":" + groupId + "-" + partialArtifactId;
        } else if (id.indexOf(":") == -1) {
            newId = newId + ":" + id;
        }
        return newId;
    }

    public String legacyToDependencyKey(String id) {
        String newId = Project.legacyToStandardId(id);
        int sepIndex = newId.indexOf(58);
        if ((sepIndex = newId.indexOf(58, sepIndex + 1)) < 0) {
            Iterator i = this.dependencyMap.keySet().iterator();
            while (i.hasNext()) {
                String depId = (String)i.next();
                if (depId.equals(newId)) {
                    return depId;
                }
                if (!depId.startsWith(newId + ":")) continue;
                return depId;
            }
            newId = newId + ":jar";
        }
        return newId;
    }

    public static String standardToLegacyId(String id) {
        int i = id.indexOf(":");
        if (i > 0) {
            id = id.substring(i + 1);
        }
        return id;
    }

    public void mergeParent(Project parent) {
        this.setParent(parent);
        if (parent == null) {
            return;
        }
        if (this.getRepository() == null) {
            this.setRepository(parent.getRepository());
        }
        if (this.getName() == null) {
            this.setName(parent.getName());
        }
        if (this.getUrl() == null) {
            this.setUrl(parent.getUrl());
        }
        if (this.getLogo() == null) {
            this.setLogo(parent.getLogo());
        }
        if (this.getDescription() == null) {
            this.setDescription(parent.getDescription());
        }
        if (this.getIssueTrackingUrl() == null) {
            this.setIssueTrackingUrl(parent.getIssueTrackingUrl());
        }
        if (this.getCurrentVersion() == null) {
            this.setCurrentVersion(parent.getCurrentVersion());
        }
        if (this.getOrganization() == null) {
            this.setOrganization(parent.getOrganization());
        }
        if (this.getInceptionYear() == null) {
            this.setInceptionYear(parent.getInceptionYear());
        }
        if (this.getPackage() == null) {
            this.setPackage(parent.getPackage());
        }
        if (this.getSiteAddress() == null) {
            this.setSiteAddress(parent.getSiteAddress());
        }
        if (this.getSiteDirectory() == null) {
            this.setSiteDirectory(parent.getSiteDirectory());
        }
        if (this.getDistributionSite() == null) {
            this.setDistributionSite(parent.getDistributionSite());
        }
        if (this.getDistributionDirectory() == null) {
            this.setDistributionDirectory(parent.getDistributionDirectory());
        }
        if (this.getPomVersion() == null) {
            this.setPomVersion(parent.getPomVersion());
        }
        if (this.getGumpRepositoryId() == null) {
            this.setGumpRepositoryId(parent.getGumpRepositoryId());
        }
        if (this.getShortDescription() == null) {
            this.setShortDescription(parent.getShortDescription());
        }
        if (this.model.getGroupId() == null && parent.originalGroupId != null) {
            this.model.setGroupId(parent.model.getGroupId());
        }
        if (this.getBuild() == null) {
            this.setBuild(new Build());
            Project.mergeParent(parent.getBuild(), this.getBuild());
        } else {
            Project.mergeParent(parent.getBuild(), this.getBuild());
        }
        if (this.getMailingLists() == null || this.getMailingLists().isEmpty()) {
            this.setMailingLists(parent.getMailingLists());
        }
        if (this.getContributors() == null || this.getContributors().isEmpty()) {
            this.setContributors(parent.getContributors());
        }
        if (this.getDevelopers() == null || this.getDevelopers().isEmpty()) {
            this.setDevelopers(parent.getDevelopers());
        }
        if (this.getVersions() == null || this.getVersions().isEmpty()) {
            this.model.setVersions(parent.getVersions());
            this.resolveVersions();
        }
        if (this.getLicenses() == null || this.getLicenses().isEmpty()) {
            this.setLicenses(parent.getLicenses());
        }
        if (this.getBranches() == null || this.getBranches().isEmpty()) {
            this.setBranches(parent.getBranches());
        }
        if (this.getReports() == null || this.getReports().isEmpty()) {
            this.setReports(parent.getReports());
        }
        if (this.getPackageGroups() == null || this.getPackageGroups().isEmpty()) {
            this.setPackageGroups(parent.getPackageGroups());
        }
        this.addParentDependencies(parent.getDependencies());
    }

    private static void resolveDirectories(Build build, File basedir) throws IOException {
        Resource r;
        Iterator i = build.getResources().iterator();
        while (i.hasNext()) {
            r = (Resource)i.next();
            Project.resolveDirectory(r, basedir);
        }
        if (build.getUnitTest() != null) {
            i = build.getUnitTest().getResources().iterator();
            while (i.hasNext()) {
                r = (Resource)i.next();
                Project.resolveDirectory(r, basedir);
            }
        }
        if (build.getSourceDirectory() != null && build.getSourceDirectory().length() > 0) {
            build.setSourceDirectory(MavenUtils.makeAbsolutePath(basedir, build.getSourceDirectory()));
        }
        if (build.getAspectSourceDirectory() != null && build.getAspectSourceDirectory().length() > 0) {
            build.setAspectSourceDirectory(MavenUtils.makeAbsolutePath(basedir, build.getAspectSourceDirectory()));
        }
        if (build.getUnitTestSourceDirectory() != null && build.getUnitTestSourceDirectory().length() > 0) {
            build.setUnitTestSourceDirectory(MavenUtils.makeAbsolutePath(basedir, build.getUnitTestSourceDirectory()));
        }
        if (build.getIntegrationUnitTestSourceDirectory() != null && build.getIntegrationUnitTestSourceDirectory().length() > 0) {
            build.setIntegrationUnitTestSourceDirectory(MavenUtils.makeAbsolutePath(basedir, build.getIntegrationUnitTestSourceDirectory()));
        }
    }

    private static void mergeParent(Build parent, Build child) {
        if (parent == null) {
            return;
        }
        if (child.getDefaultGoal() == null) {
            child.setDefaultGoal(parent.getDefaultGoal());
        }
        if (child.getSourceDirectory() == null) {
            child.setSourceDirectory(parent.getSourceDirectory());
        }
        if (child.getUnitTestSourceDirectory() == null) {
            child.setUnitTestSourceDirectory(parent.getUnitTestSourceDirectory());
        }
        if (child.getIntegrationUnitTestSourceDirectory() == null) {
            child.setIntegrationUnitTestSourceDirectory(parent.getIntegrationUnitTestSourceDirectory());
        }
        if (child.getAspectSourceDirectory() == null) {
            child.setAspectSourceDirectory(parent.getAspectSourceDirectory());
        }
        if (child.getNagEmailAddress() == null) {
            child.setNagEmailAddress(parent.getNagEmailAddress());
        }
        if (child.getResources() == null || child.getResources().isEmpty()) {
            child.setResources(parent.getResources());
        }
        if (child.getSourceModifications() == null || child.getSourceModifications().isEmpty()) {
            child.setSourceModifications(parent.getSourceModifications());
        }
        if (child.getUnitTest() == null) {
            child.setUnitTest(parent.getUnitTest());
        } else {
            Project.mergeUnitTestParent(parent.getUnitTest(), child.getUnitTest());
        }
    }

    private static void mergeUnitTestParent(UnitTest parent, UnitTest child) {
        if (parent == null) {
            return;
        }
        if (child.getResources() == null || child.getResources().isEmpty()) {
            child.setResources(parent.getResources());
        }
        if (child.getIncludes() == null || child.getIncludes().isEmpty()) {
            child.setIncludes(parent.getIncludes());
        }
        if (child.getExcludes() == null || child.getExcludes().isEmpty()) {
            child.setExcludes(parent.getExcludes());
        }
    }

    private static void resolveDirectory(Resource resource, File basedir) throws IOException {
        if (resource.getDirectory() != null) {
            resource.setDirectory(MavenUtils.makeAbsolutePath(basedir, resource.getDirectory()));
        } else {
            resource.setDirectory(basedir.getCanonicalPath());
        }
    }

    public void addBranch(Branch branch) {
        this.model.addBranch(branch);
    }

    public void addContributor(Contributor contributor) {
        this.model.addContributor(contributor);
    }

    public void addDeveloper(Developer developer) {
        this.model.addDeveloper(developer);
    }

    public void addLicense(License license) {
        this.model.addLicense(license);
    }

    public void addMailingList(MailingList mailingList) {
        this.model.addMailingList(mailingList);
    }

    public void addPackageGroup(PackageGroup packageGroup) {
        this.model.addPackageGroup(packageGroup);
    }

    public void addProperty(String s, String s1) {
        this.model.addProperty(s, s1);
    }

    public void addReport(String s) {
        this.model.addReport(s);
    }

    public List getBranches() {
        return this.model.getBranches();
    }

    public Build getBuild() {
        return this.model.getBuild();
    }

    public List getContributors() {
        return this.model.getContributors();
    }

    public String getCurrentVersion() {
        return this.model.getCurrentVersion();
    }

    public List getDependencies() {
        return this.model.getDependencies();
    }

    public String getDescription() {
        return this.model.getDescription();
    }

    public List getDevelopers() {
        return this.model.getDevelopers();
    }

    public String getDistributionDirectory() {
        return this.model.getDistributionDirectory();
    }

    public String getDistributionSite() {
        return this.model.getDistributionSite();
    }

    public String getExtend() {
        return this.model.getExtend();
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public String getGumpRepositoryId() {
        return this.model.getGumpRepositoryId();
    }

    public String getInceptionYear() {
        return this.model.getInceptionYear();
    }

    public String getIssueTrackingUrl() {
        return this.model.getIssueTrackingUrl();
    }

    public List getLicenses() {
        return this.model.getLicenses();
    }

    public String getLogo() {
        return this.model.getLogo();
    }

    public List getMailingLists() {
        return this.model.getMailingLists();
    }

    public String getName() {
        return this.model.getName();
    }

    public Organization getOrganization() {
        return this.model.getOrganization();
    }

    public String getPackage() {
        return this.model.getPackage();
    }

    public List getPackageGroups() {
        return this.model.getPackageGroups();
    }

    public String getPomVersion() {
        return this.model.getPomVersion();
    }

    public Properties getProperties() {
        return this.model.getProperties();
    }

    public List getReports() {
        return this.model.getReports();
    }

    public Repository getRepository() {
        return this.model.getRepository();
    }

    public String getShortDescription() {
        return this.model.getShortDescription();
    }

    public String getSiteAddress() {
        return this.model.getSiteAddress();
    }

    public String getSiteDirectory() {
        return this.model.getSiteDirectory();
    }

    public String getUrl() {
        return this.model.getUrl();
    }

    public List getVersions() {
        return this.model.getVersions();
    }

    public void setVersions(List list) {
        this.model.setVersions(list);
        this.resolveVersions();
    }

    public void setArtifactId(String s) {
        this.model.setArtifactId(s);
    }

    public void setBranches(List list) {
        this.model.setBranches(list);
    }

    public void setBuild(Build build) {
        this.model.setBuild(build);
    }

    public void setContributors(List list) {
        this.model.setContributors(list);
    }

    public void setCurrentVersion(String s) {
        this.model.setCurrentVersion(s);
    }

    public void setDependencies(List list) {
        this.model.setDependencies(list);
        this.dependencyMap.clear();
        this.resolveDependencies();
    }

    public void setDescription(String s) {
        this.model.setDescription(s);
    }

    public void setDevelopers(List list) {
        this.model.setDevelopers(list);
    }

    public void setDistributionDirectory(String s) {
        this.model.setDistributionDirectory(s);
    }

    public void setDistributionSite(String s) {
        this.model.setDistributionSite(s);
    }

    public void setExtend(String s) {
        this.model.setExtend(s);
    }

    public void setGroupId(String s) {
        this.model.setGroupId(s);
    }

    public void setGumpRepositoryId(String s) {
        this.model.setGumpRepositoryId(s);
    }

    public void setInceptionYear(String s) {
        this.model.setInceptionYear(s);
    }

    public void setIssueTrackingUrl(String s) {
        this.model.setIssueTrackingUrl(s);
    }

    public void setLicenses(List list) {
        this.model.setLicenses(list);
    }

    public void setLogo(String s) {
        this.model.setLogo(s);
    }

    public void setMailingLists(List list) {
        this.model.setMailingLists(list);
    }

    public void setName(String s) {
        this.model.setName(s);
    }

    public void setOrganization(Organization organization) {
        this.model.setOrganization(organization);
    }

    public void setPackage(String s) {
        this.model.setPackage(s);
    }

    public void setPackageGroups(List list) {
        this.model.setPackageGroups(list);
    }

    public void setPomVersion(String s) {
        this.model.setPomVersion(s);
    }

    public void setProperties(Properties properties) {
        this.model.setProperties(properties);
    }

    public void setReports(List list) {
        this.model.setReports(list);
    }

    public void setRepository(Repository repository) {
        this.model.setRepository(repository);
    }

    public void setShortDescription(String s) {
        this.model.setShortDescription(s);
    }

    public void setSiteAddress(String s) {
        this.model.setSiteAddress(s);
    }

    public void setSiteDirectory(String s) {
        this.model.setSiteDirectory(s);
    }

    public void setUrl(String s) {
        this.model.setUrl(s);
    }

    public void addVersion(Version version) {
        if (this.versionMap != null) {
            this.versionMap.put(version.getId(), version);
        }
        this.model.addVersion(version);
    }

    public void resolveIds() {
        this.originalGroupId = this.model.getGroupId();
        if (this.model.getId() != null) {
            if (this.model.getGroupId() == null && this.model.getArtifactId() == null) {
                this.setId(this.model.getId());
            } else {
                int j;
                String id = this.model.getId();
                if (this.model.getGroupId() == null) {
                    j = id.indexOf(":");
                    if (j > 0) {
                        this.setGroupId(id.substring(0, j));
                    } else {
                        this.setGroupId(id);
                    }
                }
                if (this.model.getArtifactId() == null) {
                    j = id.indexOf(":");
                    if (j > 0) {
                        this.setArtifactId(id.substring(j + 1));
                    } else {
                        this.setArtifactId(id);
                    }
                }
            }
        } else if (this.model.getGroupId() == null) {
            this.model.setGroupId(this.model.getArtifactId());
            LOGGER.debug((Object)("No groupId found, setting to: " + this.model.getArtifactId()));
        }
    }

    private void resolveVersions() {
        this.versionMap = new HashMap();
        Iterator i = this.getVersions().iterator();
        while (i.hasNext()) {
            Version version = (Version)i.next();
            this.versionMap.put(version.getId(), version);
        }
    }

    private void resolveDependencies() {
        Iterator i = this.getDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.getId() != null) {
                if (dependency.getGroupId() == null) {
                    String id = dependency.getId();
                    int k = id.indexOf("+");
                    int j = id.indexOf(":");
                    if (k > 0) {
                        dependency.setGroupId(id.substring(0, k));
                        dependency.setArtifactId(id.replace('+', '-'));
                    } else if (j > 0) {
                        dependency.setGroupId(id.substring(0, j));
                        dependency.setArtifactId(id.substring(j + 1));
                    } else {
                        dependency.setGroupId(id);
                    }
                }
                if (dependency.getArtifactId() == null) {
                    dependency.setArtifactId(dependency.getId());
                }
            } else if (dependency.getGroupId() == null) {
                dependency.setGroupId(dependency.getArtifactId());
                LOGGER.debug((Object)("Dependency has no groupId, setting to: " + dependency.getArtifactId()));
            }
            dependency.setId(dependency.getGroupId() + ":" + dependency.getArtifactId());
            this.dependencyMap.put(dependency.getKey(), dependency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProjectAsString() throws Exception {
        ByteArrayOutputStream projectStream = new ByteArrayOutputStream();
        if (this.model.getModelEncoding() == null) {
            this.model.setModelEncoding("UTF-8");
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)projectStream, this.model.getModelEncoding());
        try {
            MavenStaxWriter writer = new MavenStaxWriter();
            writer.write((Writer)w, this.model);
        }
        finally {
            w.close();
        }
        return projectStream.toString(System.getProperty("file.encoding"));
    }

    public String toString() {
        return this.getName() == null ? super.toString() : this.getName();
    }

    public boolean equals(Object o) {
        if (o.equals(this)) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project project = (Project)o;
        return this.getId().equals(project.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

