/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.MavenException;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.plugin.PluginDefinitionHandler;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class PluginScriptParser
extends DefaultHandler {
    private final JellyScriptHousing jellyScriptHousing;
    private final PluginDefinitionHandler handler;
    private static final Log LOGGER = LogFactory.getLog((Class)PluginScriptParser.class);
    private final Set dynaTagLibDecls = new HashSet();

    PluginScriptParser(PluginDefinitionHandler handler, JellyScriptHousing jellyScriptHousing) {
        this.handler = handler;
        this.jellyScriptHousing = jellyScriptHousing;
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (!("".equals(prefix) || uri.startsWith("jelly:") || uri.startsWith("dummy") || "".equals(uri))) {
            this.dynaTagLibDecls.add(uri);
            this.handler.addPluginDynaTagDep(this.jellyScriptHousing, uri);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Caching Taglib Uri --> " + uri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        String name;
        if ("jelly:core".equals(uri) && "import".equals(localName)) {
            String importUri = attributes.getValue("uri");
            if (importUri == null) {
                importUri = attributes.getValue("file");
            }
            if (importUri == null) {
                LOGGER.debug((Object)(rawName + " does not have a uri in " + this.jellyScriptHousing.getName()));
            } else {
                LOGGER.debug((Object)(rawName + " importing from uri " + importUri));
                FileInputStream fis = null;
                try {
                    File f = new File(importUri);
                    fis = new FileInputStream(new File(importUri));
                    this.jellyScriptHousing.parse(this.handler, f.getAbsolutePath(), fis);
                }
                catch (MavenException e) {
                    LOGGER.warn((Object)("Error parsing content from uri " + importUri), (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)("Skipping: error reading from uri " + importUri));
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                        }
                    }
                }
            }
        }
        if ("project".equals(rawName)) {
            String defaultGoal = attributes.getValue("default");
            if (defaultGoal != null) {
                LOGGER.warn((Object)"DEPRECATED: the default goal should be specified in the <build> section of project.xml instead of maven.xml");
                this.handler.setDefaultGoalName(defaultGoal);
            }
        } else if ("goal".equals(rawName)) {
            name = StringUtils.deleteWhitespace((String)attributes.getValue("name"));
            String prereqs = attributes.getValue("prereqs");
            String description = attributes.getValue("description");
            this.handler.addGoal(name, prereqs, description, this.jellyScriptHousing);
        } else if ("preGoal".equals(rawName)) {
            name = attributes.getValue("name");
            this.handler.addPreGoal(name, this.jellyScriptHousing);
        } else if ("postGoal".equals(rawName)) {
            name = attributes.getValue("name");
            this.handler.addPostGoal(name, this.jellyScriptHousing);
        } else if ("taglib".equals(localName) && "jelly:define".equals(uri)) {
            String tagLibUri = attributes.getValue("uri");
            if (this.dynaTagLibDecls.contains(tagLibUri)) {
                this.handler.removePluginDynaTagDep(this.jellyScriptHousing, tagLibUri);
            }
            this.handler.addDynaTagLib(tagLibUri, this.jellyScriptHousing);
        }
    }

    public void warning(SAXParseException spe) {
        this.printParseError("Warning", spe);
    }

    public void error(SAXParseException spe) {
        this.printParseError("Error", spe);
    }

    public void fatalError(SAXParseException spe) {
        this.printParseError("Fatal Error", spe);
    }

    private void printParseError(String type, SAXParseException spe) {
        LOGGER.error((Object)(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage()));
    }
}

