/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.werkz;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.JellyScriptHousing;
import org.apache.maven.werkz.Action;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.WerkzProject;
import org.apache.maven.werkz.jelly.GoalTag;

public class MavenGoalTag
extends GoalTag {
    public void doTag(XMLOutput output) throws JellyTagException {
        Goal goal = this.getProject().getGoal(this.getName());
        if (goal == null || goal.getAction() == null) {
            super.doTag(output);
            goal = this.getProject().getGoal(this.getName());
            JellyScriptHousing currentHousing = (JellyScriptHousing)this.getContext().getVariable("maven.plugin.script.housing");
            goal.setAction(new MavenGoalAction(currentHousing));
        }
    }

    void runBodyTag(Session session) throws JellyTagException {
        MavenJellyContext context = (MavenJellyContext)this.getContext();
        this.getBody().run((JellyContext)context, context.getXMLOutput());
    }

    public WerkzProject getProject() {
        return (WerkzProject)this.getContext().getVariable("org.apache.commons.jelly.werkz.Project");
    }

    public class MavenGoalAction
    implements Action {
        private final JellyScriptHousing housing;

        public MavenGoalAction(JellyScriptHousing housing) {
            this.housing = housing;
            if (housing == null) {
                throw new NullPointerException("Plugin Housing can not be null");
            }
        }

        public void performAction(Session session) throws Exception {
            MavenJellyContext oldContext = (MavenJellyContext)MavenGoalTag.this.getContext();
            MavenJellyContext context = this.housing.getProject().getContext();
            MavenGoalTag.this.setContext(context);
            MavenGoalTag.this.runBodyTag(session);
            MavenGoalTag.this.setContext(oldContext);
        }

        public boolean requiresAction() {
            return true;
        }
    }
}

