/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.werkz;

import java.util.Iterator;
import java.util.Set;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.GoalToJellyScriptHousingMapper;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.werkz.NoActionDefinitionException;
import org.apache.maven.werkz.NoSuchGoalException;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.UnattainableGoalException;
import org.apache.maven.werkz.WerkzProject;
import org.apache.maven.werkz.jelly.JellySession;
import org.apache.maven.werkz.jelly.WerkzTagSupport;

public class MavenAttainGoalTag
extends WerkzTagSupport {
    private String name;

    public Session createSession() {
        Session session = (Session)this.getContext().getVariable("maven.session.global");
        JellySession newSession = new JellySession(((MavenJellyContext)this.getContext()).getXMLOutput());
        Iterator i = session.getAttributes().keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            newSession.setAttribute(key, session.getAttribute(key));
        }
        return newSession;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        WerkzProject project = this.getProject();
        if (project == null) {
            throw new JellyTagException("No Project available");
        }
        this.invokeBody(output);
        try {
            Set pluginSet;
            Session session = this.createSession();
            MavenJellyContext baseContext = (MavenJellyContext)((Object)session.getAttribute("maven.goalAttainmentContext"));
            GoalToJellyScriptHousingMapper mapper = (GoalToJellyScriptHousingMapper)session.getAttribute("maven.plugin.mapper");
            PluginManager pluginManager = (PluginManager)session.getAttribute("maven.plugin.manager");
            try {
                pluginSet = pluginManager.prepAttainGoal(this.getName(), baseContext, mapper);
            }
            catch (Exception e) {
                throw new JellyTagException((Throwable)e);
            }
            project.attainGoal(this.getName(), session);
            pluginManager.addDelayedPops(pluginSet);
        }
        catch (UnattainableGoalException e) {
            Throwable root = e.getRootCause();
            if (root != null) {
                if (root instanceof JellyTagException) {
                    throw (JellyTagException)root;
                }
                if (root instanceof UnattainableGoalException) {
                    throw new JellyTagException((Throwable)e);
                }
            }
            e.fillInStackTrace();
            throw new JellyTagException((Throwable)e);
        }
        catch (NoActionDefinitionException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (NoSuchGoalException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    public void invokeBody(XMLOutput output) throws JellyTagException {
        MavenJellyContext baseContext = (MavenJellyContext)((Object)this.createSession().getAttribute("maven.goalAttainmentContext"));
        this.getBody().run((JellyContext)baseContext, output);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WerkzProject getProject() {
        return (WerkzProject)this.getContext().getVariable("org.apache.commons.jelly.werkz.Project");
    }
}

