/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.jelly.tags.maven.DependencyResolverException;
import org.apache.maven.jelly.tags.maven.DependencyResolverInterface;
import org.apache.maven.jelly.tags.maven.DummyAction;
import org.apache.maven.jelly.tags.maven.ListAddAction;
import org.apache.maven.jelly.tags.maven.ProjectGoal;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;
import org.apache.maven.werkz.CyclicGoalChainException;
import org.apache.maven.werkz.Goal;
import org.apache.maven.werkz.NoActionDefinitionException;
import org.apache.maven.werkz.Session;
import org.apache.maven.werkz.UnattainableGoalException;
import org.apache.maven.werkz.WerkzProject;

public class WerkzDependencyResolver
implements DependencyResolverInterface {
    private List projects = new ArrayList();
    private final List sortedGoals = new ArrayList();
    private Goal doItAll = null;
    private WerkzProject wproject = null;

    public void clear() {
        this.projects.clear();
        this.doItAll = null;
    }

    public void setProjects(List projects) {
        this.projects = projects;
    }

    protected ProjectGoal getExistingGoal(Project project) {
        ProjectGoal goal = (ProjectGoal)this.wproject.getGoal(project.getId());
        if (goal == null) {
            throw new NullPointerException("No goal exists : " + project.getId());
        }
        return goal;
    }

    protected ProjectGoal getOrCreateGoal(Project project, boolean sourceBuild) {
        ProjectGoal goal = (ProjectGoal)this.wproject.getGoal(project.getId());
        if (goal == null) {
            goal = new ProjectGoal(project, sourceBuild);
            goal.setAction(new ListAddAction(goal, this.sortedGoals));
            this.wproject.addGoal(goal);
        }
        return goal;
    }

    public void buildGraph() throws CyclicGoalChainException {
        if (this.doItAll != null) {
            return;
        }
        try {
            ProjectGoal projectGoal;
            Project project;
            this.wproject = new WerkzProject();
            this.doItAll = new Goal("DO_IT_ALL");
            this.doItAll.setAction(new DummyAction());
            Iterator iter = this.projects.iterator();
            while (iter.hasNext()) {
                project = (Project)iter.next();
                projectGoal = this.getOrCreateGoal(project, true);
                this.doItAll.addPrecursor(projectGoal);
            }
            iter = this.projects.iterator();
            while (iter.hasNext()) {
                project = (Project)iter.next();
                projectGoal = this.getExistingGoal(project);
                Iterator depIter = project.getDependencies().iterator();
                while (depIter.hasNext()) {
                    Dependency dep = (Dependency)depIter.next();
                    Project depProject = new Project();
                    depProject.setId(dep.getId());
                    ProjectGoal depGoal = this.getOrCreateGoal(depProject, false);
                    projectGoal.addPrecursor(depGoal);
                }
            }
        }
        catch (CyclicGoalChainException e) {
            this.doItAll = null;
            this.wproject = new WerkzProject();
            throw e;
        }
    }

    public List getSortedDependencies(Project project) throws DependencyResolverException {
        return this.getSortedDependencies(project, false);
    }

    public List getProjects(List goals, boolean sourceBuild) {
        ArrayList<Project> result = new ArrayList<Project>();
        Iterator iter = goals.iterator();
        while (iter.hasNext()) {
            ProjectGoal goal = (ProjectGoal)iter.next();
            if (!sourceBuild && (sourceBuild || !goal.getSourceBuild())) continue;
            result.add(goal.getProject());
        }
        return result;
    }

    public List getSortedDependencies(Project project, boolean sourceBuild) throws DependencyResolverException {
        try {
            this.buildGraph();
            this.sortedGoals.clear();
            Session session = new Session();
            ProjectGoal g = this.getExistingGoal(project);
            g.attain(session);
        }
        catch (CyclicGoalChainException e) {
            throw new DependencyResolverException("A cycle was detected", e);
        }
        catch (UnattainableGoalException e) {
            throw new DependencyResolverException("An invalid goal was called", e);
        }
        catch (NoActionDefinitionException e) {
            throw new DependencyResolverException("An invalid goal was called", e);
        }
        return this.getProjects(this.sortedGoals, sourceBuild);
    }

    public List getSortedDependencies(boolean sourceBuild) throws DependencyResolverException {
        try {
            this.buildGraph();
            this.sortedGoals.clear();
            Session session = new Session();
            this.doItAll.attain(session);
            return this.getProjects(this.sortedGoals, sourceBuild);
        }
        catch (CyclicGoalChainException e) {
            throw new DependencyResolverException("A cycle was detected", e);
        }
        catch (UnattainableGoalException e) {
            throw new DependencyResolverException("An invalid goal was called", e);
        }
        catch (NoActionDefinitionException e) {
            throw new DependencyResolverException("An invalid goal was called", e);
        }
    }
}

