/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.jelly.tags.maven.DependencyResolverException;
import org.apache.maven.jelly.tags.maven.DependencyResolverInterface;
import org.apache.maven.jelly.tags.maven.WerkzDependencyResolver;
import org.apache.maven.project.Project;

public class DependencyResolver
implements DependencyResolverInterface {
    private final DependencyResolverInterface impl;

    public DependencyResolver() {
        String prop = "maven.core.dependencyresolver";
        String type = System.getProperty(prop);
        try {
            this.impl = type == null ? new WerkzDependencyResolver() : (DependencyResolverInterface)Class.forName(type).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + type);
        }
    }

    public DependencyResolver(DependencyResolverInterface impl) {
        this.impl = impl;
    }

    public void clear() {
        this.impl.clear();
    }

    public void setProjects(List projects) {
        this.impl.setProjects(projects);
    }

    public List getSortedDependencies(Project project) throws DependencyResolverException {
        return this.impl.getSortedDependencies(project);
    }

    public List getSortedDependencies(Project project, boolean sourceBuild) throws DependencyResolverException {
        return this.impl.getSortedDependencies(project, sourceBuild);
    }

    public List getSortedDependencies(boolean sourceBuild) throws DependencyResolverException {
        return this.impl.getSortedDependencies(sourceBuild);
    }

    public static Project getProject(List projects, String id) {
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            Project project = (Project)iter.next();
            if (!project.getId().equals(id)) continue;
            return project;
        }
        return null;
    }
}

