/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly.tags.maven;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.tags.BaseTagSupport;
import org.apache.maven.project.Resource;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class CopyResources
extends BaseTagSupport {
    private static final Log LOGGER = LogFactory.getLog((Class)CopyResources.class);
    private List resources;
    private String todir;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        if (this.resources == null || this.todir == null) {
            LOGGER.warn((Object)"resources or todir was null");
            return;
        }
        Iterator iter = this.resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            String directoryName = resource.getDirectory();
            if (directoryName == null) continue;
            File directory = new File(directoryName);
            if (directory.exists() && directory.isDirectory() && directory.canRead()) {
                PatternSet.NameEntry entry;
                StringBuffer targetDirectoryBuffer = new StringBuffer(this.todir);
                String targetPath = resource.getTargetPath();
                if (targetPath != null && !"".equals(targetPath.trim())) {
                    targetDirectoryBuffer.append('/').append(targetPath);
                }
                File targetDirectory = new File(targetDirectoryBuffer.toString());
                Copy copyTask = new Copy();
                copyTask.setProject(this.getMavenContext().getAntProject());
                copyTask.setTodir(targetDirectory);
                copyTask.setPreserveLastModified(true);
                copyTask.setFiltering(resource.isFiltering());
                copyTask.setOverwrite(resource.isFiltering());
                FileSet fileSet = new FileSet();
                fileSet.setDir(directory);
                if (resource.getIncludes().isEmpty()) {
                    PatternSet.NameEntry entry2 = fileSet.createInclude();
                    entry2.setName("**/**");
                }
                Iterator incIter = resource.getIncludes().iterator();
                while (incIter.hasNext()) {
                    String include = (String)incIter.next();
                    entry = fileSet.createInclude();
                    entry.setName(include);
                }
                incIter = resource.getExcludes().iterator();
                while (incIter.hasNext()) {
                    String exclude = (String)incIter.next();
                    entry = fileSet.createExclude();
                    entry.setName(exclude);
                }
                copyTask.addFileset(fileSet);
                copyTask.execute();
                continue;
            }
            LOGGER.debug((Object)"todir is either not a directory, not writable or not there");
        }
    }

    public void setResources(List list) {
        this.resources = list;
    }

    public void setTodir(String string) {
        this.todir = string;
    }
}

