/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jelly;

import java.io.IOException;
import java.util.Stack;
import org.apache.commons.jelly.XMLOutput;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.xml.sax.SAXException;

public class JellyBuildListener
implements BuildListener {
    private XMLOutput out;
    private Stack taskStack = new Stack();
    private boolean debug;
    protected boolean emacsMode = false;

    public JellyBuildListener(XMLOutput out) {
        this.out = out;
        this.debug = false;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void isDebug(boolean newDebug) {
        this.setDebug(newDebug);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void buildFinished(BuildEvent event) {
    }

    public void buildStarted(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > 2 && !this.isDebug()) {
            return;
        }
        try {
            if (this.emacsMode) {
                this.out.write(event.getMessage() + "\n");
                this.out.flush();
                return;
            }
            if (!this.taskStack.isEmpty()) {
                this.out.write("    [" + this.taskStack.peek() + "] ");
            }
            switch (event.getPriority()) {
                case 0: {
                    this.out.write("[ERROR] ");
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.out.write("[VERBOSE] ");
                    break;
                }
                case 4: {
                    this.out.write("[DEBUG] ");
                }
            }
            this.out.write(event.getMessage() + "\n");
            this.out.flush();
        }
        catch (SAXException e) {
            System.err.println(event.getMessage());
            System.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
        this.taskStack.pop();
    }

    public void taskStarted(BuildEvent event) {
        this.taskStack.push(event.getTask().getTaskName());
    }
}

