/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.maven.MavenException;
import org.apache.maven.MavenSession;
import org.apache.maven.MavenUtils;
import org.apache.maven.UnknownGoalException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.project.Project;
import org.apache.maven.verifier.ChecksumVerificationException;
import org.apache.maven.verifier.RepoConfigException;
import org.apache.maven.verifier.UnsatisfiedDependencyException;
import org.apache.maven.werkz.NoActionDefinitionException;
import org.apache.maven.werkz.NoSuchGoalException;
import org.apache.maven.werkz.UnattainableGoalException;

public class App {
    public static final String POM_FILE_NAME = "project.xml";
    private static final int CONSOLE_WIDTH = 80;
    private static final Properties LINKS_PROPERTIES = new Properties();
    private static final Log LOGGER = LogFactory.getLog((Class)App.class);
    private static final String LS = System.getProperty("line.separator", "\n");
    private static final String OPT_CONSOLE_BANNER = "b";
    private static final String OPT_DEBUG = "X";
    private static final String OPT_DISPLAY_GOALS = "g";
    private static final String OPT_DISPLAY_HELP = "h";
    private static final String OPT_DISPLAY_INFO = "i";
    private static final String OPT_DISPLAY_PLUGIN_HELP = "P";
    private static final String OPT_DISPLAY_STACKTRACE = "e";
    private static final String OPT_DISPLAY_USAGE = "u";
    private static final String OPT_DISPLAY_VERSION = "v";
    private static final String OPT_EMACS_OUTPUT = "E";
    private static final String OPT_FIND_POM_DESCRIPTOR = "f";
    private static final String OPT_QUIET = "q";
    private static final String OPT_SET_POM_DESCRIPTOR = "p";
    private static final String OPT_SET_SYSTEM_PROPERTY = "D";
    private static final String OPT_WORK_OFFLINE = "o";
    private static final String OPT_WORKING_DIR = "d";
    private static final int RC_BAD_ARG = 10;
    private static final int RC_BAD_JELLY = 80;
    private static final int RC_BAD_REPO = 40;
    private static final int RC_EMPTY_GOAL = 50;
    private static final int RC_FAILED_DEPENDENCY = 100;
    private static final int RC_GOAL_FAILED = 60;
    private static final int RC_INIT_ERROR = 20;
    private static final int RC_JELLY_FAILED = 70;
    private static final int RC_NO_GOAL = 30;
    private static final int RC_OK = 0;
    private static final int RC_OTHER_FAILURE = 90;
    private static final int WRAP_INDENT = 35;
    private CommandLine commandLine;
    private MavenSession mavenSession;
    private MavenJellyContext rootContext;
    private Writer writer;

    public static void main(String[] args) {
        Date start = new Date();
        App app = new App();
        app.doMain(args, start);
    }

    protected static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        if (min > 0L) {
            return min + MavenUtils.getMessage("formatTime.minutes") + secs + MavenUtils.getMessage("formatTime.seconds");
        }
        return secs + MavenUtils.getMessage("formatTime.seconds");
    }

    public void doMain(String[] args, Date fullStart) {
        this.initializeMain(args);
        this.displayHelp();
        this.displayVersion();
        int returnCode = 0;
        if (!this.getCli().hasOption(OPT_CONSOLE_BANNER)) {
            this.printConsoleMavenHeader();
        }
        if (!MavenSession.getRootDescriptorFile().exists()) {
            LOGGER.warn((Object)MavenUtils.getMessage("build.no.pom.found"));
            LOGGER.warn((Object)"");
        }
        boolean failed = false;
        boolean displayStackTrace = this.getCli().hasOption(OPT_DISPLAY_STACKTRACE) || this.getCli().hasOption(OPT_DEBUG);
        try {
            this.mavenSession.initialize();
            this.displayInfo();
            this.displayProjectHelp();
            this.displayPluginHelp();
            if (this.getCli().hasOption(OPT_DISPLAY_GOALS)) {
                this.displayGoals();
                this.exit(returnCode);
            } else {
                this.mavenSession.attainGoals(this.mavenSession.getRootProject(), this.getCli().getArgList());
            }
        }
        catch (UnsatisfiedDependencyException e) {
            failed = true;
            this.displayBuildFailed(e, false, true, displayStackTrace);
            returnCode = 100;
        }
        catch (ChecksumVerificationException e) {
            failed = true;
            this.displayBuildFailed(e, false, true, displayStackTrace);
            returnCode = 100;
        }
        catch (UnknownGoalException e) {
            failed = true;
            LOGGER.info((Object)MavenUtils.getMessage("line"));
            LOGGER.info((Object)MavenUtils.getMessage("build.unknownGoalException", e.getGoalName()));
            this.displayBuildFailed(e, false, false, displayStackTrace);
            returnCode = 30;
        }
        catch (NoSuchGoalException e) {
            failed = true;
            this.displayBuildFailed(e, false, true, displayStackTrace);
            returnCode = 30;
        }
        catch (RepoConfigException e) {
            failed = true;
            this.displayBuildFailed(e, false, true, displayStackTrace);
            returnCode = 40;
        }
        catch (NoActionDefinitionException e) {
            failed = true;
            LOGGER.info((Object)MavenUtils.getMessage("line"));
            LOGGER.info((Object)MavenUtils.getMessage("build.internalError"));
            LOGGER.info((Object)MavenUtils.getMessage("build.noActionDefinitionException", e.getGoal().getName()));
            this.displayBuildFailed(e, true, false, displayStackTrace);
            returnCode = 50;
        }
        catch (UnattainableGoalException e) {
            failed = true;
            this.displayBuildFailed(e, false, true, displayStackTrace);
            returnCode = e.getCause() instanceof JellyException ? 70 : 60;
        }
        catch (JellyException e) {
            failed = true;
            this.displayBuildFailed(e, true, true, displayStackTrace);
            returnCode = 80;
        }
        catch (MavenException e) {
            failed = true;
            this.displayBuildFailed(e, "Unknown error reading project".equals(e.getMessage()), true, displayStackTrace);
            returnCode = 90;
        }
        catch (Throwable t) {
            failed = true;
            this.displayBuildFailed(t, true, true, displayStackTrace);
            returnCode = 90;
        }
        if (!failed) {
            LOGGER.warn((Object)MavenUtils.getMessage("line"));
            LOGGER.warn((Object)MavenUtils.getMessage("build.successful"));
        }
        LOGGER.warn((Object)MavenUtils.getMessage("line"));
        Date fullStop = new Date();
        DateFormat defaultDate = DateFormat.getDateTimeInstance(0, 1);
        long fullDiff = fullStop.getTime() - fullStart.getTime();
        LOGGER.warn((Object)MavenUtils.getMessage("build.total.time", App.formatTime(fullDiff)));
        LOGGER.warn((Object)MavenUtils.getMessage("build.finished.time", defaultDate.format(fullStop)));
        long mb = 0x100000L;
        System.gc();
        Runtime r = Runtime.getRuntime();
        LOGGER.warn((Object)MavenUtils.getMessage("build.final.memory", (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M"));
        LOGGER.warn((Object)MavenUtils.getMessage("line"));
        this.exit(returnCode);
    }

    public MavenJellyContext getRootContext() {
        return this.rootContext;
    }

    public void initialize(String[] args) throws ParseException, MalformedURLException, IOException {
        this.setCli(CLIManager.parse(args));
        this.initializeSystemProperties();
        this.initializeRootContext();
        this.initializeMavenSession();
        this.customizeLogging();
    }

    public void initializeSystemProperties() {
        if (this.getCli().hasOption(OPT_SET_SYSTEM_PROPERTY)) {
            String[] defStrs = this.getCli().getOptionValues(OPT_SET_SYSTEM_PROPERTY);
            for (int i = 0; i < defStrs.length; ++i) {
                this.setCliProperty(defStrs[i]);
            }
        }
    }

    public void setRootContext(MavenJellyContext rootContext) {
        this.rootContext = rootContext;
    }

    protected void displayGoals() {
        this.displayGoals(false, null);
    }

    protected void displayGoals(boolean pluginOnly, String plugin) {
        String title = MavenUtils.getMessage("displayGoals.title");
        if (pluginOnly) {
            title = plugin == null ? MavenUtils.getMessage("displayGoals.title.pluginOnly.null") : MavenUtils.getMessage("displayGoals.title.pluginOnly.notNull") + plugin;
        }
        LOGGER.info((Object)title);
        LOGGER.info((Object)this.format("", title.length(), '='));
        Set goals = this.mavenSession.getAllGoalNames();
        this.displayGoals(pluginOnly, plugin, goals);
    }

    protected void exit(int status) {
        System.exit(status);
    }

    protected String format(String orig, int width, char pad) {
        if (orig.length() >= width) {
            return orig;
        }
        StringBuffer buf = new StringBuffer().append(orig);
        int diff = width - orig.length();
        for (int i = 0; i < diff; ++i) {
            buf.append(pad);
        }
        return buf.toString();
    }

    protected CommandLine getCli() {
        return this.commandLine;
    }

    protected void initializeRootContext() throws IOException {
        this.writer = new OutputStreamWriter(System.out);
        XMLOutput output = XMLOutput.createXMLOutput((Writer)this.writer, (boolean)false);
        if (this.getCli().hasOption(OPT_WORKING_DIR)) {
            String workingDir = this.getCli().getOptionValue(OPT_WORKING_DIR);
            File dir = new File(workingDir);
            if (!dir.isAbsolute()) {
                workingDir = dir.getAbsolutePath();
            }
            System.setProperty("user.dir", workingDir);
        }
        File basedir = new File(System.getProperty("user.dir"));
        MavenJellyContext c = MavenUtils.createContext(basedir);
        this.setRootContext(c);
        c.setXMLOutput(output);
        if (this.getCli().hasOption(OPT_QUIET)) {
            Logger.getLogger((String)"org.apache.maven").setLevel(Level.ERROR);
        }
        if (this.getCli().hasOption(OPT_DEBUG)) {
            this.getRootContext().setDebugOn(Boolean.TRUE);
            Logger.getLogger((String)"org.apache.maven").setLevel(Level.DEBUG);
        } else {
            this.getRootContext().setDebugOn(Boolean.FALSE);
        }
        if (this.getCli().hasOption(OPT_EMACS_OUTPUT)) {
            this.getRootContext().setEmacsModeOn(Boolean.TRUE);
        } else {
            this.getRootContext().setEmacsModeOn(Boolean.FALSE);
        }
        if (this.getCli().hasOption(OPT_WORK_OFFLINE)) {
            System.setProperty("maven.mode.online", "false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printConsoleMavenHeader() {
        Properties p = new Properties();
        InputStream is = this.getClass().getResourceAsStream("/driver.properties");
        try {
            p.load(is);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MavenUtils.getMessage("printConsoleMavenHeader.error") + e));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
            }
        }
        LOGGER.info((Object)" __  __");
        LOGGER.info((Object)"|  \\/  |__ _Apache__ ___");
        LOGGER.info((Object)"| |\\/| / _` \\ V / -_) ' \\  ~ intelligent projects ~");
        LOGGER.info((Object)("|_|  |_\\__,_|\\_/\\___|_||_|  v. " + p.getProperty("maven.application.version")));
        LOGGER.info((Object)"");
    }

    protected void setCli(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    protected String wrapConsoleMessage(String msg, int wrapIndent, int lineWidth) {
        if (msg.indexOf(10) < 0 && msg.indexOf(13) < 0) {
            return this.wrapConsoleLine(msg, wrapIndent, lineWidth);
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(msg, "\n\r");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (token.length() <= 0) continue;
            buf.append(this.wrapConsoleLine(token, wrapIndent, lineWidth));
            buf.append(LS);
        }
        return buf.toString();
    }

    private void customizeLogging() {
        Iterator iter = this.getRootContext().getVariableNames();
        Properties log4jProperties = new Properties();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            if (!propertyName.startsWith("log4j")) continue;
            log4jProperties.put(propertyName, this.getRootContext().getVariable(propertyName));
        }
        PropertyConfigurator.configure((Properties)log4jProperties);
        log4jProperties = null;
        iter = null;
    }

    private void displayBugReportHelp() {
        LOGGER.info((Object)MavenUtils.getMessage("line"));
        StringBuffer sb = new StringBuffer();
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line1")).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line2")).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line3", LINKS_PROPERTIES.get("faqUrl"))).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line4")).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line5", LINKS_PROPERTIES.get("usersMailingListUrl"))).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line6", LINKS_PROPERTIES.get("issueTrackingUrl"))).append('\n');
        sb.append(MavenUtils.getMessage("displayBugReportHelp.line7"));
        LOGGER.info((Object)"");
        LOGGER.info((Object)sb.toString());
        LOGGER.info((Object)"");
    }

    private void displayBuildFailed(Throwable t, boolean displayBugReportHelp, boolean displayErrors, boolean displayStackTrace) {
        if (displayBugReportHelp) {
            this.displayBugReportHelp();
        }
        if (displayErrors) {
            this.displayThrowable(t, displayStackTrace);
        }
        LOGGER.warn((Object)MavenUtils.getMessage("line"));
        LOGGER.warn((Object)MavenUtils.getMessage("build.failed"));
    }

    private void displayDefaultGoal(String goalName, String goalDescription, boolean newLine) {
        if ("".equals(goalName)) {
            return;
        }
        String msgPrefix = this.format("[" + goalName + "]", 35, ' ') + " ";
        if (goalDescription == null) {
            goalDescription = "( NO DEFAULT GOAL )";
        }
        if (newLine) {
            msgPrefix = LS + msgPrefix;
        }
        LOGGER.info((Object)(msgPrefix + this.wrapConsoleMessage(goalDescription, 36, 80)));
    }

    private void displayGoal(String goalName, String goalDescription) {
        if ("".equals(goalName)) {
            goalName = "( NO GOAL )";
        }
        String msgPrefix = this.format("  " + goalName + "  ", 35, '.') + " ";
        LOGGER.info((Object)(msgPrefix + this.wrapConsoleMessage(goalDescription, 36, 80)));
    }

    private void displayGoals(boolean pluginOnly, String plugin, Set goals) {
        HashMap map = new HashMap();
        Iterator i = goals.iterator();
        while (i.hasNext()) {
            ArrayList<String> l;
            String goal = (String)i.next();
            String pluginName = "";
            int index = goal.indexOf(58);
            if (index >= 0) {
                pluginName = goal.substring(0, index);
            }
            if ((l = (ArrayList<String>)map.get(pluginName)) == null) {
                l = new ArrayList<String>();
                map.put(pluginName, l);
            }
            l.add(goal.substring(index + 1));
        }
        List goalList = (List)map.get("");
        if (goalList != null) {
            Iterator i2 = goalList.iterator();
            while (i2.hasNext()) {
                String goal = (String)i2.next();
                if (!map.containsKey(goal)) continue;
                i2.remove();
                ArrayList pluginGoals = (ArrayList)map.get(goal);
                if (pluginGoals != null) continue;
                pluginGoals = new ArrayList();
                map.put(goal, pluginGoals);
            }
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        ArrayList<String> undocumentedGoals = new ArrayList<String>();
        Iterator i3 = keys.iterator();
        while (i3.hasNext()) {
            String pluginName = (String)i3.next();
            if (pluginOnly) {
                if (plugin == null) {
                    this.displayDefaultGoal(pluginName, this.mavenSession.getGoalDescription(pluginName), false);
                    continue;
                }
                if (!pluginName.equals(plugin)) continue;
            }
            this.displayDefaultGoal(pluginName, this.mavenSession.getGoalDescription(pluginName), true);
            List l = (List)map.get(pluginName);
            Collections.sort(l);
            Iterator j = l.iterator();
            while (j.hasNext()) {
                String goalName = (String)j.next();
                String fullGoalName = pluginName.length() == 0 ? goalName : pluginName + ":" + goalName;
                String goalDescription = this.mavenSession.getGoalDescription(fullGoalName);
                if (goalDescription != null) {
                    this.displayGoal(goalName, goalDescription);
                    continue;
                }
                undocumentedGoals.add(fullGoalName);
            }
        }
        if (!undocumentedGoals.isEmpty()) {
            this.displayGoalsWithoutDescriptions(undocumentedGoals);
        }
        LOGGER.info((Object)"");
    }

    private void displayGoalsWithoutDescriptions(List list) {
        LOGGER.info((Object)"");
        LOGGER.info((Object)MavenUtils.getMessage("displayGoalsWithoutDescriptions.info"));
        LOGGER.info((Object)"");
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String goalName = (String)i.next();
            LOGGER.info((Object)("  " + goalName));
        }
    }

    private void displayHelp() {
        if (this.getCli().hasOption(OPT_DISPLAY_HELP)) {
            CLIManager.displayHelp();
            LOGGER.info((Object)"");
            this.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayInfo() {
        if (this.getCli().hasOption(OPT_DISPLAY_INFO)) {
            CLIManager.displayInfo();
            LOGGER.info((Object)"");
            LOGGER.info((Object)MavenUtils.getMessage("displayInfo.info1"));
            Iterator i = this.mavenSession.getPluginList().iterator();
            while (i.hasNext()) {
                LOGGER.info((Object)("  " + i.next()));
            }
            Properties buildProperties = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(System.getProperty("user.home") + "/build.properties");
                buildProperties.load(fis);
            }
            catch (IOException e) {
                LOGGER.error((Object)(MavenUtils.getMessage("displayInfo.error") + e.getMessage()));
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug((Object)"WARNING: Cannot close stream!", (Throwable)e);
                    }
                    fis = null;
                }
            }
            LOGGER.info((Object)(MavenUtils.getMessage("displayInfo.info2") + buildProperties));
            this.exit(0);
        }
    }

    private void displayPluginHelp() throws MavenException {
        if (this.getCli().hasOption(OPT_DISPLAY_PLUGIN_HELP)) {
            Project project;
            String plugin = this.getCli().getOptionValue(OPT_DISPLAY_PLUGIN_HELP);
            this.displayGoals(true, plugin);
            if (plugin != null && (project = this.mavenSession.getPluginProjectFromGoal(plugin)) != null && project.getDescription() != null) {
                LOGGER.info((Object)this.wrapConsoleMessage(project.getDescription(), 0, 80));
            }
            this.exit(0);
        }
    }

    private void displayProjectHelp() throws MavenException {
        if (this.getCli().hasOption(OPT_DISPLAY_USAGE)) {
            Set goals = this.mavenSession.getProjectGoals(this.mavenSession.getRootProject());
            String title = MavenUtils.getMessage("displayProjectHelp.title");
            LOGGER.info((Object)title);
            LOGGER.info((Object)this.format("", title.length(), '='));
            LOGGER.info((Object)"");
            Project rootProject = this.mavenSession.getRootProject();
            if (rootProject.getBuild() != null && rootProject.getBuild().getDefaultGoal() != null) {
                String defaultGoal = rootProject.getBuild().getDefaultGoal();
                String msg = MavenUtils.getMessage("displayGoals.defaultGoal") + defaultGoal;
                LOGGER.info((Object)this.wrapConsoleMessage(msg, 36, 80));
            }
            this.displayGoals(false, null, goals);
            String msg = this.mavenSession.getRootProject().getDescription();
            if (msg != null) {
                LOGGER.info((Object)this.wrapConsoleMessage(msg, 0, 80));
            }
            this.exit(0);
        }
    }

    private void displayThrowable(Throwable t, boolean displayStackTrace) {
        LOGGER.info((Object)MavenUtils.getMessage("line"));
        if (displayStackTrace) {
            LOGGER.info((Object)MavenUtils.getMessage("build.errors.stack"));
        }
        for (Throwable localThrowable = t; localThrowable != null; localThrowable = localThrowable.getCause()) {
            if (localThrowable instanceof JellyException) {
                JellyException jellyEx = (JellyException)localThrowable;
                if (jellyEx.getCause() == null) {
                    LOGGER.info((Object)(MavenUtils.getMessage("exception.cause") + jellyEx.getReason()));
                }
                if (!displayStackTrace) continue;
                LOGGER.info((Object)MavenUtils.getMessage("build.jellyException.file", jellyEx.getFileName()));
                LOGGER.info((Object)MavenUtils.getMessage("build.jellyException.element", jellyEx.getElementName()));
                LOGGER.info((Object)MavenUtils.getMessage("build.jellyException.line", Integer.toString(jellyEx.getLineNumber())));
                LOGGER.info((Object)MavenUtils.getMessage("build.jellyException.column", Integer.toString(jellyEx.getColumnNumber())));
                continue;
            }
            if (localThrowable.getLocalizedMessage() != null) {
                LOGGER.info((Object)(MavenUtils.getMessage("exception.cause") + localThrowable.getLocalizedMessage()));
                continue;
            }
            LOGGER.info((Object)(MavenUtils.getMessage("exception.cause") + localThrowable.getClass().getName()));
        }
        if (displayStackTrace) {
            LOGGER.info((Object)"");
            LOGGER.info((Object)MavenUtils.getMessage("build.stacktrace"), t);
        }
    }

    private void displayVersion() {
        if (this.getCli().hasOption(OPT_DISPLAY_VERSION)) {
            this.printConsoleMavenHeader();
            this.exit(0);
        }
    }

    private File find(File start, String suffix) {
        if (start == null) {
            return null;
        }
        File dir = start.getAbsoluteFile();
        File file = new File(dir, suffix);
        return file.exists() ? file : this.find(dir.getParentFile(), suffix);
    }

    private File find(String filename) {
        return this.find(new File(""), filename);
    }

    private File getDescriptorFile() throws IOException {
        File descriptorFile = null;
        String descriptorName = null;
        descriptorName = this.getCli().hasOption(OPT_SET_POM_DESCRIPTOR) ? this.getCli().getOptionValue(OPT_SET_POM_DESCRIPTOR) : POM_FILE_NAME;
        if (this.getCli().hasOption(OPT_FIND_POM_DESCRIPTOR)) {
            descriptorFile = this.find(descriptorName);
            if (descriptorFile == null) {
                descriptorFile = new File(descriptorName);
            }
        } else {
            descriptorFile = new File(descriptorName);
        }
        if (this.getCli().hasOption(OPT_SET_POM_DESCRIPTOR) && !descriptorFile.exists()) {
            throw new FileNotFoundException("Project file '" + descriptorName + "' not found");
        }
        descriptorFile = descriptorFile.getAbsoluteFile();
        if (!this.getCli().hasOption(OPT_WORKING_DIR)) {
            System.setProperty("user.dir", descriptorFile.getParentFile().getCanonicalPath());
        }
        return descriptorFile;
    }

    private void initializeMain(String[] args) {
        int returnCode = 0;
        try {
            this.initialize(args);
        }
        catch (ParseException e) {
            LOGGER.info((Object)e.getLocalizedMessage());
            CLIManager.displayHelp();
            returnCode = 10;
        }
        catch (IOException e) {
            LOGGER.info((Object)e.getLocalizedMessage());
            returnCode = 20;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnCode = 20;
        }
        if (returnCode != 0) {
            LOGGER.info((Object)"");
            this.exit(returnCode);
        }
    }

    private void initializeMavenSession() throws IOException {
        this.mavenSession = new MavenSession();
        this.mavenSession.setRootContext(this.getRootContext());
        MavenSession.setRootDescriptorFile(this.getDescriptorFile());
    }

    private void setCliProperty(String defStr) {
        String name = null;
        String value = null;
        int equalLoc = defStr.indexOf("=");
        if (equalLoc <= 0) {
            name = defStr.trim();
            value = "true";
        } else {
            name = defStr.substring(0, equalLoc).trim();
            value = defStr.substring(equalLoc + 1).trim();
        }
        if (name.length() > 0) {
            System.setProperty(name, value);
        }
    }

    private String wrapConsoleLine(String msg, int wrapIndent, int lineWidth) {
        int offset = lineWidth - wrapIndent;
        if (msg.length() <= offset) {
            return msg;
        }
        BreakIterator bIter = BreakIterator.getWordInstance();
        StringBuffer buf = new StringBuffer();
        String pad = " ";
        int currentPos = 0;
        bIter.setText(msg);
        while (offset < bIter.getText().getEndIndex()) {
            if (Character.isWhitespace(bIter.getText().first())) {
                msg = msg.substring(1);
                bIter.setText(msg);
                continue;
            }
            currentPos = bIter.preceding(offset);
            buf.append(msg.substring(0, currentPos));
            buf.append(LS);
            for (int i = 0; i != wrapIndent && i < lineWidth; ++i) {
                buf.append(pad);
            }
            msg = msg.substring(currentPos);
            bIter.setText(msg);
        }
        while (Character.isWhitespace(msg.charAt(0))) {
            msg = msg.substring(1);
        }
        buf.append(msg);
        return buf.toString();
    }

    static {
        URL urlLog4j = App.class.getResource("/log4j.properties");
        if (urlLog4j == null) {
            throw new RuntimeException("Configuration error: can not find the resource log4j.properties");
        }
        PropertyConfigurator.configure((URL)urlLog4j);
        URL urlLinks = App.class.getResource("/links.properties");
        if (urlLinks == null) {
            throw new RuntimeException("Configuration error: can not find the resource links.properties");
        }
        try {
            LINKS_PROPERTIES.load(urlLinks.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Configuration error: Unable to load the resource links.properties", e);
        }
    }
}

