/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.AbstractMavenComponent;
import org.apache.maven.MavenException;
import org.apache.maven.MavenUtils;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.Project;

public class MavenSession
extends AbstractMavenComponent {
    public static final String BUILD_START_GOAL = "build:start";
    public static final String BUILD_END_GOAL = "build:end";
    public static final String DRIVER_SCRIPT_NAME = "driver.jelly";
    private MavenJellyContext rootContext;
    private static File rootDescriptorFile;
    private Project rootProject;
    private PluginManager pluginManager = new PluginManager(this);

    public void setRootContext(MavenJellyContext context) {
        this.rootContext = context;
    }

    public MavenJellyContext getRootContext() {
        return this.rootContext;
    }

    public static void setRootDescriptorFile(File descriptorFile) {
        rootDescriptorFile = descriptorFile;
    }

    public static File getRootDescriptorFile() {
        return rootDescriptorFile;
    }

    public void setRootProject(Project project) {
        this.rootProject = project;
    }

    public Project getRootProject() {
        return this.rootProject;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void initialize() throws Exception {
        this.getRootContext().setMavenSession(this);
        this.initializePluginManager();
        this.initializeRootProject();
    }

    public Set getAllGoalNames() {
        return this.getPluginManager().getGoalNames();
    }

    public String getGoalDescription(String goalName) {
        return this.getPluginManager().getGoalDescription(goalName);
    }

    private void initializePluginManager() throws Exception {
        this.getPluginManager().initialize();
    }

    private void initializeRootProject() throws MavenException {
        File descriptorFile = MavenSession.getRootDescriptorFile();
        if (descriptorFile.exists()) {
            if (descriptorFile.length() == 0L) {
                throw new MavenException(MavenUtils.getMessage("empty.descriptor.error", descriptorFile.getName()));
            }
            this.setRootProject(MavenUtils.getProject(descriptorFile, this.getRootContext()));
        } else {
            Project globalProject = new Project();
            globalProject.setId("Global Project");
            globalProject.setFile(descriptorFile);
            this.getRootContext().setProject(globalProject);
            globalProject.setContext(this.getRootContext());
            this.setRootProject(globalProject);
        }
    }

    public void attainGoals(Project project, List goals) throws Exception {
        this.pluginManager.attainGoals(project, goals);
    }

    public Project getPluginProjectFromGoal(String goal) throws MavenException {
        return this.pluginManager.getPluginProjectFromGoal(goal);
    }

    public Set getProjectGoals(Project project) throws MavenException {
        return this.pluginManager.getGoalNames(project);
    }

    public Collection getPluginList() {
        return this.pluginManager.getPluginList();
    }
}

