/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.multiproject.harmonizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.multiproject.harmonizer.MultiDependency;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Project;

public class DependencyHarmonizer {
    private Map deps = new HashMap();
    private int numberOfProjects;
    private static final int NOT_SET = -1;
    private int numOfArtifacts = -1;

    public Iterator getDependencies() {
        ArrayList list = new ArrayList();
        list.addAll(this.deps.values());
        Collections.sort(list);
        return list.iterator();
    }

    public void build(List projects) {
        this.numberOfProjects = projects.size();
        Iterator projectIter = projects.iterator();
        while (projectIter.hasNext()) {
            Project project = (Project)projectIter.next();
            Iterator depIter = project.getDependencies().iterator();
            while (depIter.hasNext()) {
                Dependency dep = (Dependency)depIter.next();
                String id = dep.getId();
                MultiDependency multiDep = null;
                if (this.deps.containsKey(id)) {
                    multiDep = (MultiDependency)this.deps.get(id);
                } else {
                    multiDep = new MultiDependency();
                    multiDep.setId(id);
                    this.deps.put(id, multiDep);
                }
                multiDep.add(project, dep.getVersion());
            }
        }
    }

    public int getNumberOfProjects() {
        return this.numberOfProjects;
    }

    public int getNumberOfDependencies() {
        return this.deps.size();
    }

    public int getNumberOfArtifacts() {
        if (this.numOfArtifacts != -1) {
            return this.numOfArtifacts;
        }
        this.numOfArtifacts = 0;
        Iterator iter = this.deps.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            MultiDependency dep = (MultiDependency)this.deps.get(key);
            this.numOfArtifacts += dep.getNumberOfVersions();
        }
        return this.numOfArtifacts;
    }

    public double getConvergence() {
        if (this.getNumberOfArtifacts() > 0) {
            return (double)this.getNumberOfDependencies() / (double)this.getNumberOfArtifacts();
        }
        return 100.0;
    }
}

