/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateParser;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.http.PutInputStream;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class HttpWagon
extends AbstractWagon {
    private static final int DEFAULT_NUMBER_OF_ATTEMPTS = 3;
    private static final int SC_NULL = -1;
    private HttpClient client;
    private int numberOfAttempts = 3;
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");

    public void openConnection() {
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        String username = null;
        String password = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
        }
        String host = this.getRepository().getHost();
        if (StringUtils.isNotEmpty((String)username) && StringUtils.isNotEmpty((String)password)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            this.client.getState().setCredentials(null, host, (Credentials)creds);
            this.client.getState().setAuthenticationPreemptive(true);
        }
        HostConfiguration hc = new HostConfiguration();
        if (this.proxyInfo != null) {
            String proxyUsername = this.proxyInfo.getUserName();
            String proxyPassword = this.proxyInfo.getPassword();
            String proxyHost = this.proxyInfo.getHost();
            int proxyPort = this.proxyInfo.getPort();
            String proxyNtlmHost = this.proxyInfo.getNtlmHost();
            String proxyNtlmDomain = this.proxyInfo.getNtlmDomain();
            if (proxyHost != null) {
                hc.setProxy(proxyHost, proxyPort);
                if (proxyUsername != null && proxyPassword != null) {
                    Object creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    this.client.getState().setProxyCredentials(null, proxyHost, (Credentials)creds);
                    this.client.getState().setAuthenticationPreemptive(true);
                }
            }
        }
        hc.setHost(host);
        this.client.setHostConfiguration(hc);
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String url = this.getRepository().getUrl() + "/" + resourceName;
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        PutMethod putMethod = new PutMethod(url);
        try {
            PutInputStream is = new PutInputStream(source, resource, (Wagon)this, this.getTransferEventSupport());
            putMethod.setRequestBody((InputStream)is);
        }
        catch (FileNotFoundException e) {
            this.fireTransferError(resource, e, 6);
            throw new ResourceDoesNotExistException("Source file does not exist: " + source, (Throwable)e);
        }
        int statusCode = -1;
        int attempt = 0;
        this.fireTransferDebug("about to execute client for put");
        while (statusCode == -1 && attempt < this.getNumberOfAttempts()) {
            try {
                this.firePutStarted(resource, source);
                statusCode = this.client.executeMethod((HttpMethod)putMethod);
            }
            catch (HttpRecoverableException e) {
                ++attempt;
            }
            catch (IOException e) {
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
        }
        this.fireTransferDebug(url + " - Status code: " + statusCode);
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            case -1: {
                throw new TransferFailedException("Failed to transfer file: " + url + " after " + attempt + " attempts");
            }
            case 403: {
                throw new AuthorizationException("Access denied to: " + url);
            }
            case 404: {
                throw new ResourceDoesNotExistException("File: " + url + " does not exist");
            }
            default: {
                throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
            }
        }
        putMethod.releaseConnection();
        this.firePutCompleted(resource, source);
    }

    public void closeConnection() {
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.get(resourceName, destination, 0L);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.get(resourceName, destination, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        boolean retValue = false;
        String url = this.getRepository().getUrl() + "/" + resourceName;
        GetMethod getMethod = new GetMethod(url);
        try {
            getMethod.addRequestHeader("Cache-control", "no-cache");
            getMethod.addRequestHeader("Cache-store", "no-store");
            getMethod.addRequestHeader("Pragma", "no-cache");
            getMethod.addRequestHeader("Expires", "0");
            getMethod.addRequestHeader("Accept-Encoding", "gzip");
            if (timestamp > 0L) {
                SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
                fmt.setTimeZone(GMT_TIME_ZONE);
                Header hdr = new Header("If-Modified-Since", fmt.format(new Date(timestamp)));
                this.fireTransferDebug("sending ==> " + hdr + "(" + timestamp + ")");
                getMethod.addRequestHeader(hdr);
            }
            int statusCode = -1;
            int attempt = 0;
            while (statusCode == -1 && attempt < this.getNumberOfAttempts()) {
                try {
                    statusCode = this.client.executeMethod((HttpMethod)getMethod);
                }
                catch (HttpRecoverableException e) {
                    ++attempt;
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
            }
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 304: {
                    boolean e = false;
                    return e;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url + " after " + attempt + " attempts");
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
            InputStream is = null;
            Header contentLengthHeader = getMethod.getResponseHeader("Content-Length");
            if (contentLengthHeader != null) {
                try {
                    long contentLength = Integer.valueOf(contentLengthHeader.getValue()).intValue();
                    resource.setContentLength(contentLength);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("error parsing content length header '" + contentLengthHeader.getValue() + "' " + e);
                }
            }
            Header lastModifiedHeader = getMethod.getResponseHeader("Last-Modified");
            long lastModified = 0L;
            if (lastModifiedHeader != null) {
                try {
                    lastModified = DateParser.parseDate((String)lastModifiedHeader.getValue()).getTime();
                }
                catch (DateParseException e) {
                    this.fireTransferDebug("Unable to parse last modified header");
                }
                this.fireTransferDebug("last-modified = " + lastModifiedHeader.getValue() + " (" + lastModified + ")");
            }
            if (timestamp == 0L || timestamp < lastModified) {
                retValue = true;
                Header contentEncoding = getMethod.getResponseHeader("Content-Encoding");
                boolean isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding.getValue());
                try {
                    is = getMethod.getResponseBodyAsStream();
                    if (isGZipped) {
                        is = new GZIPInputStream(is);
                    }
                    this.getTransfer(resource, destination, is);
                }
                catch (IOException e) {
                    boolean deleted;
                    this.fireTransferError(resource, e, 5);
                    if (destination.exists() && !(deleted = destination.delete())) {
                        destination.deleteOnExit();
                    }
                    String msg = "Error occurred while deploying to remote repository:" + this.getRepository();
                    throw new TransferFailedException(msg, (Throwable)e);
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
                if (lastModified > 0L) {
                    resource.setLastModified(lastModified);
                }
            } else {
                this.fireTransferDebug("Local file is newer: not downloaded");
            }
            boolean bl = retValue;
            return bl;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    public void setNumberOfAttempts(int numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.getRepository().getUrl() + "/" + destinationDirectory;
        GetMethod getMethod = new GetMethod(url);
        try {
            getMethod.addRequestHeader("Cache-control", "no-cache");
            getMethod.addRequestHeader("Cache-store", "no-store");
            getMethod.addRequestHeader("Pragma", "no-cache");
            getMethod.addRequestHeader("Expires", "0");
            int statusCode = -1;
            int attempt = 0;
            while (statusCode == -1 && attempt < this.getNumberOfAttempts()) {
                try {
                    statusCode = this.client.executeMethod((HttpMethod)getMethod);
                }
                catch (HttpRecoverableException e) {
                    ++attempt;
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
            }
            this.fireTransferDebug(url + " - Status code: " + statusCode);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url + " after " + attempt + " attempts");
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + url + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
            InputStream is = null;
            is = getMethod.getResponseBodyAsStream();
            List list = HtmlFileListParser.parseFileList((String)url, (InputStream)is);
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("Could not read response body.", (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String url = this.getRepository().getUrl() + "/" + resourceName;
        HeadMethod headMethod = new HeadMethod(url);
        int statusCode = -1;
        int attempt = 0;
        try {
            while (statusCode == -1 && attempt < this.getNumberOfAttempts()) {
                try {
                    statusCode = this.client.executeMethod((HttpMethod)headMethod);
                }
                catch (HttpRecoverableException e) {
                    ++attempt;
                }
                catch (IOException e) {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
            }
            switch (statusCode) {
                case 200: {
                    boolean bl = true;
                    return bl;
                }
                case 304: {
                    boolean bl = true;
                    return bl;
                }
                case -1: {
                    throw new TransferFailedException("Failed to transfer file: " + url + " after " + attempt + " attempts");
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Not authorized.");
                }
                case 407: {
                    throw new AuthorizationException("Not authorized by proxy.");
                }
                case 404: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
        }
        finally {
            headMethod.releaseConnection();
        }
    }
}

