/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scm.release;

import java.io.File;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.scm.release.AbstractPomTransformer;
import org.apache.maven.project.Project;
import org.apache.maven.util.HttpUtils;
import org.dom4j.Node;

public class SnapshotResolver
extends AbstractPomTransformer {
    public String selectNodesXPathExpression() {
        return "/project/dependencies/dependency[version='SNAPSHOT']";
    }

    public String selectNodeXPath() {
        return "version";
    }

    public String getNodeContent(Node node) throws Exception {
        String artifactId;
        String groupId;
        String timestampVersion = "SNAPSHOT";
        Node idNode = node.selectSingleNode("id");
        String artifactType = "jar";
        if (idNode != null) {
            artifactId = groupId = idNode.getText();
        } else {
            Node artifactIdNode = node.selectSingleNode("artifactId");
            Node groupIdNode = node.selectSingleNode("groupId");
            groupId = groupIdNode.getText();
            artifactId = artifactIdNode.getText();
        }
        Node typeIdNode = node.selectSingleNode("type");
        if (typeIdNode != null) {
            artifactType = typeIdNode.getText();
        }
        Project project = (Project)this.getVariables().get("pom");
        File snapshotVersionFile = new File(this.getProject().getParentFile(), artifactId + "-snapshot-version");
        Iterator i = project.getContext().getMavenRepoRemote().iterator();
        while (i.hasNext()) {
            String remoteRepo = (String)i.next();
            String url = remoteRepo + "/" + groupId + "/" + artifactType + "s/" + artifactId + "-snapshot-version";
            try {
                HttpUtils.getFile((String)url, (File)snapshotVersionFile, (boolean)true, (boolean)false, (String)((String)this.getVariables().get("maven.proxy.host")), (String)((String)this.getVariables().get("maven.proxy.port")), (String)((String)this.getVariables().get("maven.proxy.username")), (String)((String)this.getVariables().get("maven.proxy.password")));
            }
            catch (Exception e) {
                System.out.println("Can't retrieve snapshot version file: " + e.getLocalizedMessage());
            }
            if (!snapshotVersionFile.exists()) continue;
            timestampVersion = FileUtils.readFileToString((File)snapshotVersionFile, null);
        }
        return timestampVersion;
    }

    public void transformNode(Node node) throws Exception {
        Node version = node.selectSingleNode(this.selectNodeXPath());
        version.setText(this.getNodeContent(node));
    }

    public Node getTransformedNode(Node node) throws Exception {
        Node transformedNode = (Node)node.clone();
        Node version = transformedNode.selectSingleNode(this.selectNodeXPath());
        version.setText(this.getNodeContent(transformedNode));
        return transformedNode;
    }
}

