/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scm.release;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.scm.release.PomTransformer;
import org.apache.maven.plugins.scm.release.Transformation;
import org.dom4j.Document;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.dom4j.Dom4jXPath;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class AbstractPomTransformer
implements PomTransformer {
    private File project;
    private Document document;
    private File outputFile;
    private Map variables;
    private List selectedNodes;
    private List transformations;

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    public void setProject(File project) {
        this.project = project;
    }

    public File getProject() {
        return this.project;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public List getSelectedNodes() {
        if (this.selectedNodes == null) {
            try {
                this.selectNodes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.selectedNodes;
    }

    public void setSelectedNodes(List selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public int getSelectedNodeCount() {
        return this.getSelectedNodes().size();
    }

    public List getTransformations() {
        if (this.transformations == null) {
            this.createTransformations();
        }
        return this.transformations;
    }

    public void createTransformations() {
        this.transformations = new ArrayList();
        Iterator i = this.getSelectedNodes().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Node)) continue;
            Transformation transformation = new Transformation(this);
            transformation.setNode((Node)o);
            this.transformations.add(transformation);
        }
    }

    public void transformNodes() throws Exception {
        Iterator i = this.getSelectedNodes().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Node)) continue;
            this.transformNode((Node)o);
        }
    }

    public abstract String selectNodesXPathExpression();

    public abstract void transformNode(Node var1) throws Exception;

    public void selectNodes() throws Exception {
        SAXReader reader = new SAXReader();
        reader.setXMLFilter((XMLFilter)new XMLFilterImpl(){

            public void endElement(String uri, String localName, String qName) throws SAXException {
                super.endElement("", localName, "");
            }

            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                super.startElement("", localName, "", atts);
            }
        });
        this.setDocument(reader.read(this.getProject()));
        Dom4jXPath xpath = new Dom4jXPath(this.selectNodesXPathExpression());
        this.setSelectedNodes(xpath.selectNodes((Object)this.getDocument()));
    }

    public void write() throws Exception {
        this.write(null);
    }

    public void write(String encoding) throws Exception {
        OutputStream os = null;
        if (this.getOutputFile() != null) {
            FileUtils.copyFile((File)this.getOutputFile(), (File)new File(this.getOutputFile() + ".backup"));
            os = new FileOutputStream(this.getOutputFile());
        } else {
            os = new PrintStream(System.out);
        }
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        if (encoding != null) {
            format.setEncoding(encoding);
        }
        XMLWriter writer = new XMLWriter(format){

            protected boolean isNamespaceDeclaration(Namespace ns) {
                return "http://maven.apache.org/POM/3.0.0".equals(ns.getURI());
            }
        };
        writer.setOutputStream(os);
        writer.write(this.getDocument());
        writer.flush();
        writer.close();
    }
}

