/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.ant;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.jelly.tags.ant.PropsHandler;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.JavaEnvUtils;

public class DefaultPropsHandler
implements PropsHandler {
    protected Map properties;
    protected Map userProperties = new HashMap();
    protected Map inheritedProperties = new HashMap();

    public DefaultPropsHandler() {
        this.properties = new HashMap();
    }

    public DefaultPropsHandler(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setUserProperty(String key, String value) {
        this.userProperties.put(key, value);
        this.setProperty(key, value);
    }

    public void setNewProperty(String key, String value) {
        if (this.getProperty(key) == null) {
            this.setProperty(key, value);
        }
    }

    public void setInheritedProperty(String key, String value) {
        this.inheritedProperties.put(key, value);
        this.setUserProperty(key, value);
    }

    public void setPropertyIfUndefinedByUser(String key, String value) {
        if (!this.getUserProperties().contains(key)) {
            this.setProperty(key, value);
        }
    }

    public String getProperty(String key) {
        if (key == null) {
            return null;
        }
        return (String)this.properties.get(key);
    }

    public String getUserProperty(String key) {
        if (key == null) {
            return null;
        }
        return (String)this.userProperties.get(key);
    }

    public Hashtable getProperties() {
        return new Hashtable(this.properties);
    }

    public Hashtable getUserProperties() {
        return new Hashtable(this.userProperties);
    }

    public Hashtable getInheritedProperties() {
        return new Hashtable(this.inheritedProperties);
    }

    public void copyUserProperties(Project other) {
        Hashtable userProps = this.getUserProperties();
        Hashtable inheritedProps = this.getInheritedProperties();
        Enumeration e = userProps.keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            if (inheritedProps.contains(name)) continue;
            Object value = userProps.get(name);
            other.setUserProperty(name.toString(), value.toString());
        }
    }

    public void copyInheritedProperties(Project other) {
        Hashtable inheritedProps = this.getInheritedProperties();
        Enumeration e = inheritedProps.keys();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (other.getUserProperty(name) != null) continue;
            Object value = inheritedProps.get(name);
            other.setInheritedProperty(name, value.toString());
        }
    }

    public void setSystemProperties() {
        Properties systemProps = System.getProperties();
        Enumeration e = ((Hashtable)systemProps).keys();
        while (e.hasMoreElements()) {
            Object name = e.nextElement();
            String value = ((Hashtable)systemProps).get(name).toString();
            this.setPropertyIfUndefinedByUser(name.toString(), value);
        }
    }

    public void setJavaVersionProperty() {
        String javaVersion = JavaEnvUtils.getJavaVersion();
        this.setPropertyIfUndefinedByUser("ant.java.version", javaVersion);
    }
}

