/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.announcement;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public class MailUtils {
    private static final String ADDRESS_SEPARATOR = ",";

    public static String sendMail(String server, String client, String from, String to, String subject, String msg) {
        if (server == null) {
            return "no smtp server configured";
        }
        if (client == null) {
            return "no smtp client configured";
        }
        if (to == null) {
            return "no to address specified";
        }
        if (from == null) {
            return "no from address specified";
        }
        if (msg == null) {
            return "no message specified";
        }
        if (subject == null) {
            return "no subject specified";
        }
        SMTPClient smtpClient = new SMTPClient();
        System.out.println("Connecting to SMTP Server [" + server + "]");
        try {
            smtpClient.connect(server);
            int reply = smtpClient.getReplyCode();
            if (!SMTPReply.isPositiveCompletion((int)reply)) {
                smtpClient.disconnect();
                return "SMTP server [" + server + "] refused connection.";
            }
            smtpClient.login(client);
            smtpClient.setSender(from);
            StringTokenizer st = new StringTokenizer(to.toString(), ADDRESS_SEPARATOR);
            while (st.hasMoreTokens()) {
                smtpClient.addRecipient(st.nextToken().trim());
            }
            System.out.println("Sending message from [" + from + "] to [" + to + "]");
            Writer clientWriter = smtpClient.sendMessageData();
            if (clientWriter == null) {
                return "Could not send data to the SMTP server";
            }
            PrintWriter writer = new PrintWriter(clientWriter);
            SimpleSMTPHeader header = new SimpleSMTPHeader(from, to, subject);
            writer.write(header.toString());
            writer.write(msg);
            writer.close();
            if (!smtpClient.completePendingCommand()) {
                return "Could not send the SMTP message";
            }
            smtpClient.logout();
            smtpClient.disconnect();
            return "ok";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

