/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.SAXException;

public class TextScript
implements Script {
    private String text;

    public TextScript() {
    }

    public TextScript(String text) {
        this.text = text;
    }

    public String toString() {
        return super.toString() + "[text=" + this.text + "]";
    }

    public void trimWhitespace() {
        this.text = this.text.trim();
    }

    public void trimStartWhitespace() {
        char ch;
        int index;
        int length = this.text.length();
        for (index = 0; index < length && Character.isWhitespace(ch = this.text.charAt(index)); ++index) {
        }
        if (index > 0) {
            this.text = this.text.substring(index);
        }
    }

    public void trimEndWhitespace() {
        char ch;
        int index = this.text.length();
        while (--index >= 0 && Character.isWhitespace(ch = this.text.charAt(index))) {
        }
        if (++index < this.text.length()) {
            this.text = this.text.substring(0, index);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Script compile() {
        return this;
    }

    public void run(JellyContext context, XMLOutput output) throws JellyTagException {
        if (this.text != null) {
            try {
                output.write(this.text);
            }
            catch (SAXException e) {
                throw new JellyTagException("could not write to XMLOutput", e);
            }
        }
    }
}

