/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.xdoc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;

public final class LocaleUtil {
    public static Locale codeToLocale(String localeCode) {
        if (localeCode == null) {
            return null;
        }
        if (localeCode.toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        Locale locale = null;
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(localeCode, "_");
        if (tokenizer.countTokens() > 3) {
            System.out.println("The locale code=[" + localeCode + "] is not a valid java.util.Locale");
            return null;
        }
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken();
                }
            }
        }
        locale = new Locale(language, country, variant);
        return locale;
    }

    public static Locale[] codesToLocales(String localeCodes) {
        if (localeCodes == null) {
            return null;
        }
        ArrayList<Locale> arrays = new ArrayList<Locale>();
        StringTokenizer strToken = new StringTokenizer(localeCodes, ", ");
        while (strToken.hasMoreTokens()) {
            String locale = strToken.nextToken().trim();
            Locale currentLocale = LocaleUtil.codeToLocale(locale);
            if (!Arrays.asList(Locale.getAvailableLocales()).contains(currentLocale)) {
                System.out.println("The current locale parsed defined by '" + locale + "' is not available in the Java version " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"));
            }
            arrays.add(currentLocale);
        }
        return arrays.toArray(new Locale[0]);
    }

    public static String displayName(Locale locale) {
        return LocaleUtil.displayName(locale, null);
    }

    public static String displayName(Locale locale, Locale localeWanted) {
        if (locale == null) {
            return null;
        }
        String localeAsStr = null;
        localeAsStr = localeWanted == null ? locale.getDisplayName() : locale.getDisplayName(localeWanted);
        char[] letters = localeAsStr.toCharArray();
        letters[0] = Character.toUpperCase(letters[0]);
        return new String(letters);
    }
}

