/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.util;

import java.util.ArrayList;
import org.apache.maven.util.EnhancedStringTokenizer;

public final class RepositoryUtils {
    public static String getSCMConnectionSeparator(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.indexOf("|") != -1) {
            return "|";
        }
        return ":";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] splitSCMConnection(String connection) {
        if (connection == null) {
            throw new NullPointerException("repository connection is null");
        }
        if (connection.length() < 5) {
            throw new IllegalArgumentException("repository connection is too short");
        }
        if (!connection.startsWith("scm:")) {
            throw new IllegalArgumentException("repository connection must start with scm:");
        }
        String delimiter = RepositoryUtils.getSCMConnectionSeparator(connection);
        String modifiedConnection = "scm" + delimiter + connection.substring(4);
        EnhancedStringTokenizer tok = new EnhancedStringTokenizer(modifiedConnection, delimiter);
        String[] tokens = RepositoryUtils.tokenizerToArray(tok);
        if (tokens.length < 1) return tokens;
        if (!tokens[1].equals("cvs")) return tokens;
        if (tokens.length >= 2 && tokens[2].equals("local")) {
            if (tokens.length == 6) {
                if (tokens[3].length() <= 0) return tokens;
                if (tokens[3].equals("local")) return tokens;
                throw new IllegalArgumentException("cvs local repository connection string must specify 5 tokens, or an empty 3rd token if 6");
            }
            if (tokens.length != 5) throw new IllegalArgumentException("cvs local repository connection string doesn't contain five tokens");
            String[] newTokens = new String[]{tokens[0], tokens[1], tokens[2], "", tokens[3], tokens[4]};
            return newTokens;
        }
        if (tokens.length == 7 && tokens[2].equals("pserver") && tokens[4].startsWith("@")) {
            String[] newTokens = new String[]{tokens[0], tokens[1], tokens[2], tokens[3] + tokens[4], tokens[5], tokens[6]};
            return newTokens;
        }
        if (tokens.length == 6) return tokens;
        throw new IllegalArgumentException("cvs repository connection string doesn't contain six tokens");
    }

    public static String[] tokenizerToArray(EnhancedStringTokenizer tok) {
        ArrayList<String> l = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            l.add(tok.nextToken());
        }
        return l.toArray(new String[l.size()]);
    }
}

