/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.perforcelib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class PerforceChangeLogParser
implements ChangeLogParser {
    private static final SimpleDateFormat PERFORCE_TIMESTAMP = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$perforcelib$PerforceChangeLogParser == null ? (class$org$apache$maven$perforcelib$PerforceChangeLogParser = PerforceChangeLogParser.class$("org.apache.maven.perforcelib.PerforceChangeLogParser")) : class$org$apache$maven$perforcelib$PerforceChangeLogParser));
    private static final int GET_REVISION = 1;
    private static final int GET_COMMENT_BEGIN = 2;
    private static final int GET_COMMENT = 3;
    private static final String COMMENT_DELIMITER = "";
    private static final String FILE_BEGIN_TOKEN = "//";
    private static final String pattern = "^\\.\\.\\. #(\\d+) change (\\d+) .* on (.*) by (.*)@";
    private Map entries = new TreeMap(Collections.reverseOrder());
    private int status = 1;
    private ChangeLogEntry currentLogEntry;
    private String currentFile;
    private RE revisionRegexp;
    private ChangeLog changeLog;
    private Date beforeDate;
    private int prefixLength;
    static /* synthetic */ Class class$org$apache$maven$perforcelib$PerforceChangeLogParser;

    public PerforceChangeLogParser() {
        try {
            this.revisionRegexp = new RE(pattern);
        }
        catch (RESyntaxException ignored) {
            LOG.error((Object)"Could not create regexp to parse perforce log file", (Throwable)ignored);
        }
    }

    public void init(ChangeLog changeLog) {
        this.changeLog = changeLog;
        this.setDateRange();
        String conn = changeLog.getRepositoryConnection();
        String filespec = conn.substring(conn.lastIndexOf(58) + 1);
        this.prefixLength = 1 + filespec.lastIndexOf(47);
    }

    public void cleanup() {
    }

    public Collection parse(InputStream anInputStream) throws IOException {
        BufferedReader stream = new BufferedReader(new InputStreamReader(anInputStream));
        String line = null;
        block5: while ((line = stream.readLine()) != null) {
            switch (this.status) {
                case 1: {
                    this.processGetRevision(line);
                    continue block5;
                }
                case 2: {
                    this.status = 3;
                    continue block5;
                }
                case 3: {
                    this.processGetComment(line);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.status);
        }
        return this.entries.values();
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (this.beforeDate != null && entry.getDate().before(this.beforeDate)) {
            return;
        }
        Integer key = new Integer(this.revisionRegexp.getParen(2));
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private void processGetRevision(String line) {
        if (line.startsWith(FILE_BEGIN_TOKEN)) {
            this.currentFile = line.substring(this.prefixLength);
            return;
        }
        if (!this.revisionRegexp.match(line)) {
            return;
        }
        this.currentLogEntry = new ChangeLogEntry();
        this.currentLogEntry.setDate(this.parseDate(this.revisionRegexp.getParen(3)));
        this.currentLogEntry.setAuthor(this.revisionRegexp.getParen(4));
        this.status = 2;
    }

    private void processGetComment(String line) {
        if (line.equals(COMMENT_DELIMITER)) {
            this.addEntry(this.currentLogEntry, new ChangeLogFile(this.currentFile, this.revisionRegexp.getParen(1)));
            this.status = 1;
        } else {
            this.currentLogEntry.setComment(this.currentLogEntry.getComment() + line + "\n");
        }
    }

    private Date parseDate(String date) {
        try {
            return PERFORCE_TIMESTAMP.parse(date);
        }
        catch (ParseException e) {
            LOG.error((Object)"ParseException Caught", (Throwable)e);
            return null;
        }
    }

    private void setDateRange() {
        if (this.changeLog == null || this.changeLog.getRange() == null || this.changeLog.getRange().length() == 0) {
            return;
        }
        int days = Integer.parseInt(this.changeLog.getRange());
        this.beforeDate = new Date(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
    }

    public void setDateFormatInFile(String dateFormat) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

