# Documentação

Quick te ajuda a verificar como programas em Swift e Objective-C se comportam.

Fazê-lo de forma eficaz não é apenas questão de saber como usar Quick. Os guias nesse diretório podem te ajudar a escrever testes eficazes --não apenas usando Quick, mas até mesmo XCTest ou outros framework de teste.

Cada guia cobre um tópico em particular. Se você é completamente novo a teste unitário, considere lê-los na ordem que são introduzidos abaixo:

- **[Configurar Testes no seu Xcode Project](SettingUpYourXcodeProject.md)**:
  Leia isto se você esta com problemas para usar o código da sua aplicação de dentro dos seus arquivos de teste.
- **[Testes Eficazes Usando XCTest: Arrange, Act e Assert](ArrangeActAssert.md)**:
  Leia isto para aprender como escrever `XCTestcase` testes que o ajudarão a escrever código mais rápido e mais eficaz.
- **[Não Teste o Código, Verifique Comportamento](BehavioralTesting.md)**:
  Leia isto para aprender que tipos de testes te deixam mais rápido e quais os que só vão acabar te deixando mais devagar.
- **[Testes Limpos Usando Nimble Assertions](NimbleAssertions.md)**:
  Leia isto para aprender a usar Nimble para gerar melhores mensagens de falha.
  Melhores mensagens de falha ajudam a se mover mais rápido, gastando menos tempo tentando descobrir por que
     um teste falhou.
- **[Testes Organizados com Exemplos Quick e Grupos de Exemplo](QuickExamplesAndGroups.md)**:
  Leia isto para aprender como Quick pode ajudar ainda mais a escrever testes eficazes, usando *exemplos* e *grupos de  exemplos*  
- **[Testando Aplicações OS X e iOS](TestingApps.md)**:
  Leia isto para aprender mais sobre testar código que utiliza
  AppKit e UIKit frameworks.
- **[Testando com testes dublês](TestUsingTestDoubles.md)**:
  Leia isto para aprender o que são testes dublês e como usa-lôs.
- **[Reduzindo Teste Boilerplate com Assertions Compartilhados](SharedExamples.md)**:
  Leia isto para aprender como compartilhar conjuntos de assertions entre seus testes.
- **[Configurando como Quick se Comporta](ConfiguringQuick.md)**:
  Leia isto para aprender como você pode mudar como Quick se comporta quando roda os sua suite de testes.
- **[Usando Quick com Objective-C](QuickInObjectiveC.md)**:
  Leia isto se você esta com problemas para usar Quick em Objective-C.
- **[Instalando Quick](InstallingQuick.md)**:
  Leia isto para instruções de como adicionar Quick no seu projeto, usando Git submodules, CocoaPods, Carthage, ou Swift Package Manager.
- **[Instalando Arquivos Templates Quick](InstallingFileTemplates.md)**:
Leia isto para aprender como instalar arquivos templates que deixam escrever Quick specs mais rápidos.
- **[Mais Recursos](MoreResources.md)**:
  Uma lista de recursos adicionais sobre testes OS X e iOS.
- **[Troubleshooting](Troubleshooting.md)**:
  Leia isto quando você tiver outros problemas.
