# Documentation

Quick은 당신의 Swift와 Objective-C가 잘 동작하는지 확인할 수 있도록 도와줍니다. 그러나 Quick을 어떻게 사용하는지 아는 것만으로는 효과적인 방법은 아닙니다. 이 가이드는 Quick, XCTest, 또는 다른 테스트 프레임워크를 사용하는 것뿐만 아니라 효과적인 테스트를 작성하는 것을 도와줄 것입니다.

각 가이드는 특정 주제를 다루고 있습니다. 유닛 테스트에 대한 사전지식이 없는 분이라면, 아래에 소개된 순서대로 읽는 것을 추천해 드립니다.

- **[Xcode 프로젝트에 Test 설정하기](SettingUpYourXcodeProject.md)**:
  테스트 파일에서 응용 프로그램 코드를 사용하는 데 문제가 있는 경우 읽어보십시오.
- **[XCTest를 사용한 효과적인 테스트 : Arrange (환경구축), Act (실행), 그리고 Assert (동작 확인)](ArrangeActAssert.md)**:
  코드를 더 빠르고 효과적으로 작성하는 데 도움이 되는 `XCTestCase` 테스트를 작성하는 법을 배우려먼 이 글을 읽어보십시오.
- **[코드를 테스트하지 말고, 동작을 확인하라](BehavioralTesting.md)**:
  어떤 테스트가 속도를 높이고, 어떤 테스트가 속도를 낮추는지 배우려면 이 글을 읽어보십시오.
- **[Nimble Assertions를 사용하여 테스트를 더욱 간결하게 하기](NimbleAssertions.md)**:
  Nimble을 사용하여 더 나은 실패 메시지를 생성하는 방법을 배우려면 이 글을 읽어보십시오. 더 나은 실패 메시지는 테스트 실패 원인을 파악하는데 걸리는 시간을 줄여주므로 빠르게 대처할 수 있습니다.
- **[Quick Example과 Example 그룹으로 구성된 테스트](QuickExamplesAndGroups.md)**:
  Example과 Example 그룹을 사용하여 Quick이 어떻게 더 효과적인 테스트를 도와주는지 배우려면 이 글을 읽어보십시오.
- **[OS X 와 iOS 앱 테스트](TestingApps.md)**:
  AppKit과 UIKit 프레임워크를 사용하는 코드 테스팅을 배우려면 이 글을 읽어 보십시오.
- **[test doubles를 사용한 테스트](TestUsingTestDoubles.md)**:
  Test Doubles가 무엇인지, 어떻게 사용하는지 배우려면 이 글을 읽어 보십시오.
- **[Shared Assertions를 사용하여 테스트 상용구 줄이기](SharedExamples.md)**:
  테스트들 사이에 assert 집합을 공유하는 방법에 대해 배우려면 이 글을 읽어 보십시오. 
- **[Quick의 동작 방식 설정하기](ConfiguringQuick.md)**:
  Quick이 테스트를 실행할 때 동작 방식을 바꾸는 법을 배우려면 이 글을 읽어 보십시오.
- **[Objective-C에서 Quick 사용하기](QuickInObjectiveC.md)**:
  Objective-C에서 Quick을 사용하는 데 문제가 있으면 이 내용을 읽어 보십시오.
- **[Quick 설치하기](InstallingQuick.md)**:
  Git 서브 모듈, CocoaPods, Carthage, 또는 Swift Package Manager를 사용하여 프로젝트에 Quick을 추가하는 법을 읽어 보십시오.
- **[Quick 파일 템플릿 설치하기](InstallingFileTemplates.md)**:
  Quick specs를 더 빨리 작성하게 해주는 파일 템플릿을 설치하는 방법을 배우려면 이 글을 읽어 보십시오.
- **[더 많은 리소스](MoreResources.md)**:
  OS X와 iOS 테스트에 대한 추가 리소스 목록입니다.
- **[일반적인 설치 이슈들](Troubleshooting.md)**:
  다른 문제가 발생한다면 이 글을 읽어 보십시오.

