/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dataDictionary, UUID uUID, String string) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID, null);
        return schemaDescriptor;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dataDictionary, Activation activation, String string) throws StandardException {
        TransactionController transactionController = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, false);
        if (schemaDescriptor == null || schemaDescriptor.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction createSchemaConstantAction = new CreateSchemaConstantAction(string, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(string)) {
                    DDLConstantAction.executeCAPreferSubTrans(createSchemaConstantAction, transactionController, activation);
                } else {
                    try {
                        createSchemaConstantAction.executeConstantAction(activation);
                    }
                    catch (StandardException standardException) {
                        if (standardException.getMessageId().equals("X0Y68.S")) break block5;
                        throw standardException;
                    }
                }
            }
            schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        }
        return schemaDescriptor;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction createSchemaConstantAction, TransactionController transactionController, Activation activation) throws StandardException {
        TransactionController transactionController2 = null;
        TransactionController transactionController3 = null;
        try {
            transactionController2 = transactionController3 = transactionController.startNestedUserTransaction(false);
        }
        catch (StandardException standardException) {
            transactionController2 = transactionController;
        }
        while (true) {
            try {
                createSchemaConstantAction.executeConstantAction(activation, transactionController2);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("40XL1")) {
                    if (transactionController2 == transactionController3) {
                        transactionController2 = transactionController;
                        transactionController3.destroy();
                        continue;
                    }
                } else if (standardException.getMessageId().equals("X0Y68.S")) break;
                if (transactionController2 == transactionController3) {
                    transactionController3.destroy();
                }
                throw standardException;
            }
            break;
        }
        if (transactionController2 == transactionController3) {
            transactionController3.commit();
            transactionController3.destroy();
        }
    }

    final void lockTableForDDL(TransactionController transactionController, long l, boolean bl) throws StandardException {
        ConglomerateController conglomerateController = transactionController.openConglomerate(l, false, bl ? 68 : 64, 7, 5);
        conglomerateController.close();
    }

    protected String constructToString(String string, String string2) {
        return string + string2;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID uUID) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        if (!languageConnectionContext.getAuthorizationId().equals(dataDictionary.getAuthorizationDatabaseOwner()) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementTablePermission statementTablePermission;
                StatementPermission statementPermission = (StatementPermission)iterator.next();
                if (!(statementPermission instanceof StatementTablePermission) ? statementPermission instanceof StatementSchemaPermission || statementPermission instanceof StatementRoutinePermission : (statementTablePermission = (StatementTablePermission)statementPermission).getPrivType() != 2 || !statementTablePermission.getTableUUID().equals(uUID)) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission.getPermissionDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission.getPermissionDescriptor("PUBLIC", dataDictionary);
                    if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) break;
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    break;
                }
                if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) break;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                if (!(permissionsDescriptor instanceof ColPermsDescriptor) || (permissionsDescriptor = ((StatementColumnPermission)(statementTablePermission = (StatementColumnPermission)statementPermission)).getPUBLIClevelColPermsDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary)) == null) break;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                break;
            }
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List list;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        if (!languageConnectionContext.getAuthorizationId().equals(dataDictionary.getAuthorizationDatabaseOwner()) && (list = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StatementColumnPermission statementColumnPermission;
                StatementPermission statementPermission = (StatementPermission)iterator.next();
                if (statementPermission instanceof StatementSchemaPermission) continue;
                PermissionsDescriptor permissionsDescriptor = statementPermission.getPermissionDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary);
                if (permissionsDescriptor == null) {
                    permissionsDescriptor = statementPermission.getPermissionDescriptor("PUBLIC", dataDictionary);
                    if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) continue;
                    dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                    continue;
                }
                if (permissionsDescriptor.checkOwner(languageConnectionContext.getAuthorizationId())) continue;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
                if (!(permissionsDescriptor instanceof ColPermsDescriptor) || (permissionsDescriptor = (statementColumnPermission = (StatementColumnPermission)statementPermission).getPUBLIClevelColPermsDescriptor(languageConnectionContext.getAuthorizationId(), dataDictionary)) == null) continue;
                dependencyManager.addDependency(dependent, permissionsDescriptor, languageConnectionContext.getContextManager());
            }
        }
    }
}

