/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.BasicStroke;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.listener.NullGraphListener;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraphComponentEditorFactory;
import salvo.jesus.graph.visual.VisualVertex;
import salvo.jesus.graph.visual.drawing.VisualEdgePainter;
import salvo.jesus.graph.visual.drawing.VisualEdgePainterFactory;
import salvo.jesus.graph.visual.drawing.VisualEdgePainterFactoryImpl;
import salvo.jesus.graph.visual.drawing.VisualVertexPainter;
import salvo.jesus.graph.visual.drawing.VisualVertexPainterFactory;
import salvo.jesus.graph.visual.drawing.VisualVertexPainterFactoryImpl;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class VisualGraph
extends NullGraphListener
implements Serializable {
    private Graph graph;
    private List containers = new ArrayList(10);
    private List visualVertices = new ArrayList(10);
    private List visualEdges = new ArrayList(10);
    private VisualVertexPainterFactory vertexPainterFactory = VisualVertexPainterFactoryImpl.getInstance();
    private VisualEdgePainterFactory edgePainterFactory = VisualEdgePainterFactoryImpl.getInstance();
    private VisualGraphComponentEditorFactory editorFactory;
    private GraphLayoutManager layoutManager;
    int linetype = 1;

    public VisualGraph() {
    }

    public VisualGraph(Graph g) {
        this();
        this.setGraph(g);
    }

    public List getContainers() {
        return this.containers;
    }

    public void addContainer(Container c) {
        this.containers.add(c);
    }

    public void removeContainer(Container c) {
        this.containers.remove(c);
    }

    public Dimension getMaxSize() {
        int maxwidth = 0;
        int maxheight = 0;
        Iterator iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex vvertex = (VisualVertex)iterator.next();
            Rectangle rectangle = vvertex.getBounds();
            Dimension vvertexdimension = rectangle.getSize();
            if (rectangle.getY() + vvertexdimension.getHeight() > (double)maxheight) {
                maxheight = (int)(rectangle.getY() + vvertexdimension.getHeight());
            }
            if (!(rectangle.getX() + vvertexdimension.getWidth() > (double)maxwidth)) continue;
            maxwidth = (int)(rectangle.getX() + vvertexdimension.getWidth());
        }
        return new Dimension(maxwidth, maxheight);
    }

    public Point getStartDrawPoint() {
        int minx = -1;
        int miny = -1;
        Iterator iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex vvertex = (VisualVertex)iterator.next();
            Rectangle rectangle = vvertex.getBounds();
            int n = minx == -1 ? rectangle.x : (minx = minx < rectangle.x ? minx : rectangle.x);
            miny = miny == -1 ? rectangle.y : (miny < rectangle.y ? miny : rectangle.y);
        }
        return new Point(minx, miny);
    }

    public void repaint() {
        Iterator iterator = this.containers.iterator();
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            if (container == null) continue;
            container.repaint();
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        Iterator edgesiterator;
        HashSet<Edge> uniqueedges = new HashSet<Edge>();
        if (this.graph != null) {
            this.graph.removeListener(this);
        }
        this.visualEdges.clear();
        this.visualVertices.clear();
        this.graph = graph;
        Iterator verticesiterator = this.graph.getVerticesIterator();
        while (verticesiterator.hasNext()) {
            Vertex currentvertex = (Vertex)verticesiterator.next();
            this.visualVertices.add(new VisualVertex(currentvertex, this));
            edgesiterator = this.graph.getEdges(currentvertex).iterator();
            while (edgesiterator.hasNext()) {
                uniqueedges.add((Edge)edgesiterator.next());
            }
        }
        edgesiterator = uniqueedges.iterator();
        while (edgesiterator.hasNext()) {
            this.visualEdges.add(new VisualEdge((Edge)edgesiterator.next(), this));
        }
        this.graph.addListener(this);
    }

    public GraphLayoutManager getGraphLayoutManager() {
        return this.layoutManager;
    }

    public void setGraphLayoutManager(GraphLayoutManager layoutmanager) {
        this.layoutManager = layoutmanager;
    }

    public VisualVertexPainterFactory getVisualVertexPainterFactory() {
        return this.vertexPainterFactory;
    }

    public void setVisualVertexPainterFactory(VisualVertexPainterFactory newFactory) {
        this.vertexPainterFactory = newFactory;
    }

    public VisualEdgePainterFactory getVisualEdgePainterFactory() {
        return this.edgePainterFactory;
    }

    public void setVisualEdgePainterFactory(VisualEdgePainterFactory newFactory) {
        this.edgePainterFactory = newFactory;
    }

    public VisualGraphComponentEditorFactory getVisualGraphComponentEditorFactory() {
        return this.editorFactory;
    }

    public void setVisualGraphComponentEditorFactory(VisualGraphComponentEditorFactory editorFactory) {
        this.editorFactory = editorFactory;
    }

    public List getVisualVertices() {
        return this.visualVertices;
    }

    public List getVisualEdges() {
        return this.visualEdges;
    }

    private void setLinetype(int linetype) {
        int size = this.visualEdges.size();
        this.linetype = linetype;
        for (int i = 0; i < size; ++i) {
            ((VisualEdge)this.visualEdges.get(i)).setLinetype(linetype);
        }
    }

    public void setOrthogonalLine() {
        this.setLinetype(2);
    }

    public void setStraightLine() {
        this.setLinetype(1);
    }

    public void layout() {
        if (this.layoutManager != null) {
            this.layoutManager.layout();
        }
    }

    public VisualEdge getVisualEdge(Edge edge) {
        Iterator iterator = this.visualEdges.iterator();
        while (iterator.hasNext()) {
            VisualEdge visualedge = (VisualEdge)iterator.next();
            if (visualedge.getEdge() != edge) continue;
            return visualedge;
        }
        return null;
    }

    public void setVisualEdge(Edge edge, VisualEdge newVisualEdge) {
        VisualEdge existingVisualEdge = this.getVisualEdge(edge);
        if (edge != null && newVisualEdge.getEdge() == edge) {
            this.visualEdges.set(this.visualEdges.indexOf(existingVisualEdge), newVisualEdge);
        }
    }

    public VisualVertex getVisualVertex(Vertex vertex) {
        Iterator iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex visualvertex = (VisualVertex)iterator.next();
            if (visualvertex.getVertex() != vertex) continue;
            return visualvertex;
        }
        return null;
    }

    public void setVisualVertex(Vertex vertex, VisualVertex newVisualVertex) {
        VisualVertex existingVisualVertex = this.getVisualVertex(vertex);
        if (existingVisualVertex != null && vertex == newVisualVertex.getVertex()) {
            this.visualVertices.set(this.visualVertices.indexOf(existingVisualVertex), newVisualVertex);
        }
    }

    public VisualEdge getVisualEdge(int x, int y) {
        VisualEdge nearestVEdge = null;
        double leastDistance = 5.0;
        Iterator iterator = this.visualEdges.iterator();
        while (iterator.hasNext()) {
            VisualEdge currentVEdge = (VisualEdge)iterator.next();
            double currentDistance = currentVEdge.ptSegDist(x, y);
            if (!(currentDistance < leastDistance)) continue;
            leastDistance = currentDistance;
            nearestVEdge = currentVEdge;
        }
        return nearestVEdge;
    }

    public void add(Vertex vertex) throws Exception {
        this.graph.add(vertex);
    }

    public void add(Vertex vertex, Font f) throws Exception {
        this.graph.add(vertex);
        VisualVertex newvisualvertex = this.getVisualVertex(vertex);
        newvisualvertex.setFont(f);
    }

    public void addEdge(VisualVertex from, VisualVertex to) throws Exception {
        this.graph.addEdge(from.getVertex(), to.getVertex());
    }

    public void remove(Vertex vertex) throws Exception {
        this.graph.remove(vertex);
    }

    public void remove(VisualVertex vvertex) throws Exception {
        this.graph.remove(vvertex.getVertex());
    }

    public void removeEdge(Edge edge) throws Exception {
        this.graph.removeEdge(edge);
    }

    public void removeEdge(VisualEdge vedge) throws Exception {
        this.graph.removeEdge(vedge.getEdge());
    }

    public VisualVertex getNode(int x, int y) {
        Iterator iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex vvertex = (VisualVertex)iterator.next();
            if (!vvertex.getGeneralPath().contains(x, y)) continue;
            return vvertex;
        }
        return null;
    }

    public List translateToVisualVertices(Collection vertices) {
        ArrayList<VisualVertex> translated = new ArrayList<VisualVertex>(vertices);
        int i = 0;
        int size = translated.size();
        for (i = 0; i < size; ++i) {
            translated.set(i, this.getVisualVertex((Vertex)translated.get(i)));
        }
        return translated;
    }

    public List translateToVertices(Collection visualvertices) {
        ArrayList<Vertex> translated = new ArrayList<Vertex>(visualvertices);
        int i = 0;
        int size = translated.size();
        for (i = 0; i < size; ++i) {
            translated.set(i, ((VisualVertex)translated.get(i)).getVertex());
        }
        return translated;
    }

    public List translateToVisualEdges(List edges) {
        ArrayList<VisualEdge> translated = new ArrayList<VisualEdge>(edges);
        int i = 0;
        int size = translated.size();
        for (i = 0; i < size; ++i) {
            translated.set(i, this.getVisualEdge((Edge)translated.get(i)));
        }
        return translated;
    }

    public void paint(Graphics2D g2d, VisualVertex onfront) {
        Iterator iterator = this.visualEdges.iterator();
        while (iterator.hasNext()) {
            VisualEdge vedge = (VisualEdge)iterator.next();
            vedge.paint(g2d, this.layoutManager);
        }
        iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex vvertex = (VisualVertex)iterator.next();
            vvertex.paint(g2d);
        }
        if (onfront != null) {
            onfront.paint(g2d);
        }
    }

    public void paint(Graphics2D g2d) {
        this.paint(g2d, (VisualVertex)null);
    }

    public void paint(Graphics2D g2d, Line2D probableedgeline) {
        float[] dash1 = new float[]{5.0f};
        BasicStroke dashedstroke = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
        this.paint(g2d, (VisualVertex)null);
        if (probableedgeline != null) {
            Stroke originalstroke = g2d.getStroke();
            g2d.setStroke(dashedstroke);
            g2d.draw(probableedgeline);
            g2d.setStroke(originalstroke);
        }
    }

    public void afterVertexAdded(GraphAddVertexEvent e) {
        VisualVertex vvertex = new VisualVertex(e.getVertex(), this);
        this.visualVertices.add(vvertex);
        if (this.layoutManager != null) {
            this.layoutManager.addVertex(vvertex);
        }
        this.repaint();
    }

    public void afterEdgeAdded(GraphAddEdgeEvent e) {
        VisualEdge vedge = new VisualEdge(e.getEdge(), this);
        vedge.setLinetype(this.linetype);
        this.visualEdges.add(vedge);
        if (this.layoutManager != null) {
            this.layoutManager.addEdge(vedge);
        }
        this.repaint();
    }

    public void afterVertexRemoved(GraphRemoveVertexEvent e) {
        Vertex vertextoremove = e.getVertex();
        Iterator iterator = this.visualVertices.iterator();
        while (iterator.hasNext()) {
            VisualVertex visualvertex = (VisualVertex)iterator.next();
            if (visualvertex.getVertex() != vertextoremove) continue;
            if (this.layoutManager != null) {
                this.layoutManager.removeVertex(visualvertex);
            }
            this.visualVertices.remove(visualvertex);
            this.repaint();
            return;
        }
    }

    public void afterEdgeRemoved(GraphRemoveEdgeEvent e) {
        Edge edgetoremove = e.getEdge();
        Iterator iterator = this.visualEdges.iterator();
        while (iterator.hasNext()) {
            VisualEdge visualedge = (VisualEdge)iterator.next();
            if (visualedge.getEdge() != edgetoremove) continue;
            if (this.layoutManager != null) {
                this.layoutManager.removeEdge(visualedge);
            }
            this.visualEdges.remove(visualedge);
            this.repaint();
            return;
        }
    }

    public void emphasizeSubGraph(Graph subGraph, VisualVertexPainter vPainter, VisualEdgePainter ePainter) {
        Iterator vertexIterator = subGraph.getVerticesIterator();
        while (vertexIterator.hasNext()) {
            Vertex ivertex = (Vertex)vertexIterator.next();
            VisualVertex vvertex = this.getVisualVertex(ivertex);
            if (vPainter != null) {
                vvertex.setPainter(vPainter);
            }
            if (ePainter == null) continue;
            Iterator edgeIterator = subGraph.getEdges(ivertex).iterator();
            while (edgeIterator.hasNext()) {
                VisualEdge vedge = this.getVisualEdge((Edge)edgeIterator.next());
                vedge.setPainter(ePainter);
            }
        }
        this.repaint();
    }

    public void emphasizeSubGraph(Graph subGraph, VisualVertexPainter mainGraphVPainter, VisualEdgePainter mainGraphEPainter, VisualVertexPainter subGraphVPainter, VisualEdgePainter subGraphEPainter) {
        Iterator vertexIterator = this.getGraph().getVerticesIterator();
        while (vertexIterator.hasNext()) {
            Vertex ivertex = (Vertex)vertexIterator.next();
            VisualVertex vvertex = this.getVisualVertex(ivertex);
            if (mainGraphVPainter != null) {
                vvertex.setPainter(mainGraphVPainter);
            }
            if (mainGraphEPainter == null) continue;
            Iterator edgeIterator = this.getGraph().getEdges(ivertex).iterator();
            while (edgeIterator.hasNext()) {
                VisualEdge vedge = this.getVisualEdge((Edge)edgeIterator.next());
                vedge.setPainter(mainGraphEPainter);
            }
        }
        this.emphasizeSubGraph(subGraph, subGraphVPainter, subGraphEPainter);
        this.repaint();
    }
}

