/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.test;

import cc.mallet.grmm.inference.BruteForceInferencer;
import cc.mallet.grmm.inference.LoopyBP;
import cc.mallet.grmm.inference.RandomGraphs;
import cc.mallet.grmm.inference.TRP;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UndirectedGrid;
import cc.mallet.grmm.types.Variable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestRandomGraphs
extends TestCase {
    public TestRandomGraphs(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestRandomGraphs.class);
    }

    public void testAttractiveGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomAttractiveGrid(5, 0.5, r);
            System.out.println("************");
            mdl.dump();
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("attract." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testRepulsiveGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomRepulsiveGrid(5, 0.5, r);
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("repulse." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testFrustratedGraphs() throws IOException {
        Random r = new Random(31421L);
        for (int rep = 0; rep < 5; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomFrustratedGrid(5, 0.5, r);
            TRP trp = TRP.createForMaxProduct();
            trp.computeMarginals(mdl);
            Assignment assn = trp.bestAssignment();
            PrintWriter out = new PrintWriter(new FileWriter(new File("mixed." + rep + ".dot")));
            mdl.printAsDot(out, assn);
            out.close();
        }
    }

    public void testFrustratedIsGrid() throws IOException {
        Random r = new Random(0L);
        for (int rep = 0; rep < 100; ++rep) {
            UndirectedGrid mdl = RandomGraphs.randomFrustratedGrid(10, 1.0, r);
            TestRandomGraphs.assertEquals((int)280, (int)mdl.factors().size());
            TestRandomGraphs.assertEquals((int)100, (int)mdl.numVariables());
            int[] counts = new int[6];
            for (int i = 0; i < mdl.numVariables(); ++i) {
                Variable var = mdl.get(i);
                int degree = mdl.getDegree(var);
                TestRandomGraphs.assertTrue((String)("Variable " + var + " has degree " + degree), (degree >= 3 && degree <= 5 ? 1 : 0) != 0);
                int n = degree;
                counts[n] = counts[n] + 1;
            }
            TestRandomGraphs.assertEquals((int)counts[0], (int)0);
            TestRandomGraphs.assertEquals((int)counts[1], (int)0);
            TestRandomGraphs.assertEquals((int)counts[2], (int)0);
            TestRandomGraphs.assertEquals((int)counts[3], (int)4);
            TestRandomGraphs.assertEquals((int)counts[4], (int)32);
            TestRandomGraphs.assertEquals((int)counts[5], (int)64);
        }
    }

    public void testUniformGrid() {
        UndirectedGrid grid = (UndirectedGrid)RandomGraphs.createUniformGrid(3);
        TestRandomGraphs.assertEquals((int)9, (int)grid.numVariables());
        TestRandomGraphs.assertEquals((int)12, (int)grid.factors().size());
        BruteForceInferencer inf = new BruteForceInferencer();
        TableFactor joint = (TableFactor)inf.joint(grid);
        AssignmentIterator it = joint.assignmentIterator();
        while (it.hasNext()) {
            TestRandomGraphs.assertEquals((double)(-9.0 * Math.log(2.0)), (double)joint.logValue(it), (double)0.001);
            it.advance();
        }
    }

    public void testUniformGridWithObservations() {
        FactorGraph grid = RandomGraphs.createGridWithObs(new RandomGraphs.UniformFactorGenerator(), new RandomGraphs.UniformFactorGenerator(), 3);
        TestRandomGraphs.assertEquals((int)18, (int)grid.numVariables());
        TestRandomGraphs.assertEquals((int)21, (int)grid.factors().size());
        LoopyBP inf = new LoopyBP();
        inf.computeMarginals(grid);
        Iterator it = grid.variablesIterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            Factor marg = inf.lookupMarginal(var);
            AssignmentIterator assnIt = marg.assignmentIterator();
            while (assnIt.hasNext()) {
                TestRandomGraphs.assertEquals((double)(-Math.log(2.0)), (double)marg.logValue(assnIt), (double)0.001);
                assnIt.advance();
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestRandomGraphs(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestRandomGraphs.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

