/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import no.uib.cipr.matrix.distributed.CollectiveCommunications;
import no.uib.cipr.matrix.distributed.Reduction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Communicator {
    private final int rank;
    private final ExecutorService executor;
    private final CollectiveCommunications coll;
    final Object[] in;
    final Object[] out;
    final SendRecv[] send;
    final SendRecv[] recv;

    Communicator(int rank, List<Exchanger<SendRecv>> ex, CollectiveCommunications coll) {
        int i;
        this.rank = rank;
        this.coll = coll;
        if (rank < 0) {
            throw new IllegalArgumentException("rank < 0");
        }
        if (rank >= this.size()) {
            throw new IllegalArgumentException("rank >= size");
        }
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.in = new Object[this.size()];
        this.out = new Object[this.size()];
        for (i = 0; i < this.size(); ++i) {
            this.in[i] = new Object();
            this.out[i] = new Object();
        }
        this.send = new SendRecv[this.size()];
        this.recv = new SendRecv[this.size()];
        for (i = 0; i < this.size(); ++i) {
            if (i == rank) continue;
            try {
                this.send[i] = new SendRecv();
                this.recv[i] = ex.get(i).exchange(this.send[i]);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int rank() {
        return this.rank;
    }

    public int size() {
        return this.coll.size();
    }

    public void allGather(Object sendbuf, Object[] recvbuf) {
        this.coll.allGather(sendbuf, recvbuf, this.rank);
    }

    public void allReduce(Object sendbuf, Object recvbuf, Reduction op) {
        this.coll.allReduce(sendbuf, recvbuf, op, this.rank);
    }

    public void allToAll(Object[] sendbuf, Object[] recvbuf) {
        this.coll.allToAll(sendbuf, recvbuf, this.rank);
    }

    public void barrier() {
        this.coll.barrier();
    }

    public void broadcast(Object buffer, int root) {
        this.coll.broadcast(buffer, root, this.rank);
    }

    public void gather(Object sendbuf, Object[] recvbuf, int root) {
        this.coll.gather(sendbuf, recvbuf, root, this.rank);
    }

    public void reduce(Object sendbuf, Object recvbuf, Reduction op, int root) {
        this.coll.reduce(sendbuf, recvbuf, op, root, this.rank);
    }

    public void scatter(Object[] sendbuf, Object recvbuf, int root) {
        this.coll.scatter(sendbuf, recvbuf, root, this.rank);
    }

    public void send(Object data, int offset, int length, int peer) {
        this.checkArgs(data, offset, length, peer);
        this.send[peer].length = length;
        this.send[peer].sendOffset = offset;
        this.send[peer].send = data;
        CollectiveCommunications.await(this.send[peer].barrier);
    }

    public void recv(Object data, int offset, int length, int peer) {
        this.checkArgs(data, offset, length, peer);
        this.recv[peer].recvOffset = offset;
        this.recv[peer].recv = data;
        CollectiveCommunications.await(this.recv[peer].barrier);
    }

    public Future isend(final Object data, final int offset, final int length, final int peer) {
        return this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = Communicator.this.out[peer];
                synchronized (object) {
                    Communicator.this.send(data, offset, length, peer);
                }
            }
        });
    }

    public Future irecv(final Object data, final int offset, final int length, final int peer) {
        return this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = Communicator.this.in[peer];
                synchronized (object) {
                    Communicator.this.recv(data, offset, length, peer);
                }
            }
        });
    }

    public void send(Object data, int peer) {
        this.send(data, 0, Array.getLength(data), peer);
    }

    public void recv(Object data, int peer) {
        this.recv(data, 0, Array.getLength(data), peer);
    }

    public Future isend(Object data, int peer) {
        return this.isend(data, 0, Array.getLength(data), peer);
    }

    public Future irecv(Object data, int peer) {
        return this.irecv(data, 0, Array.getLength(data), peer);
    }

    public void await(Future[] future) {
        for (Future f : future) {
            this.await(f);
        }
    }

    public void await(Future f) {
        if (f == null) {
            return;
        }
        try {
            f.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkArgs(Object data, int offset, int length, int peer) {
        if (peer == this.rank) {
            throw new IllegalArgumentException("peer == rank");
        }
        if (length + offset > Array.getLength(data)) {
            throw new IllegalArgumentException("Buffer underflow");
        }
        if (peer < 0 || peer >= this.coll.size) {
            throw new IllegalArgumentException("Invalid peer");
        }
    }

    static class SendRecv
    implements Runnable {
        CyclicBarrier barrier = new CyclicBarrier(2, this);
        Object send;
        Object recv;
        int sendOffset;
        int recvOffset;
        int length;

        SendRecv() {
        }

        public void run() {
            System.arraycopy(this.send, this.sendOffset, this.recv, this.recvOffset, this.length);
        }
    }
}

