/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import salvo.jesus.graph.visual.AbstractVisualGraphComponent;
import salvo.jesus.graph.visual.ChangeStateEvent;
import salvo.jesus.graph.visual.GraphPanel;

public abstract class GraphPanelState
implements Serializable {
    GraphPanel gpanel;

    GraphPanelState(GraphPanel gpanel) {
        this.gpanel = gpanel;
    }

    GraphPanelState() {
    }

    public void setGraphPanel(GraphPanel gpanel) {
        this.gpanel = gpanel;
    }

    public GraphPanelState recommendState(ChangeStateEvent cse) {
        return cse.getRequestedState();
    }

    public GraphPanelState mousePressed(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseReleased(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseDragged(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseEntered(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseExited(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseClicked(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseMoved(MouseEvent e) {
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState keyPressed(KeyEvent e) {
        return this;
    }

    public GraphPanelState keyReleased(KeyEvent e) {
        return this;
    }

    public GraphPanelState keyTyped(KeyEvent e) {
        return this;
    }

    public void informTargetVisualGraphComponentOfMouseEvent(MouseEvent e) {
        AbstractVisualGraphComponent component = this.gpanel.getVisualGraph().getNode(e.getX(), e.getY());
        if (component == null) {
            component = this.gpanel.getVisualGraph().getVisualEdge(e.getX(), e.getY());
        }
        if (component != null) {
            component.processMouseEvent(e);
        }
    }

    public void informTargetVisualGraphComponentOfKeyEvent(KeyEvent e) {
    }

    public abstract void paint(Graphics2D var1);
}

