/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.visual.AbstractVisualGraphComponent;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.drawing.VisualVertexPainter;

public class VisualVertex
extends AbstractVisualGraphComponent {
    static Random rand = new Random();

    public VisualVertex(Vertex vertex, VisualGraph vGraph) {
        this.component = vertex;
        this.painter = vGraph.getVisualVertexPainterFactory().getPainter(this);
        this.visualGraph = vGraph;
        this.setFont(new Font("Lucida Sans", 0, 10));
        this.initLocation();
        this.rescale();
        this.setOutlinecolor(Color.black);
        this.setFillcolor(new Color(0, 225, 255));
    }

    public VisualVertex(Vertex vertex, Font f, VisualGraph vGraph) {
        this.component = vertex;
        this.painter = vGraph.getVisualVertexPainterFactory().getPainter(this);
        this.visualGraph = vGraph;
        this.setFont(f);
        this.initLocation();
        this.rescale();
        this.outlinecolor = Color.black;
        this.setFillcolor(new Color(0, 225, 255));
    }

    public VisualVertex(Vertex vertex, Shape shape, Color c, Color bgcolor, Font f, VisualGraph vGraph) {
        this.component = vertex;
        this.painter = vGraph.getVisualVertexPainterFactory().getPainter(this);
        this.visualGraph = vGraph;
        this.setFont(f);
        this.drawpath = new GeneralPath(shape);
        this.setOutlinecolor(c);
        this.setFillcolor(bgcolor);
    }

    private void initLocation() {
        boolean height = false;
        boolean maxwidth = false;
        this.drawpath = new GeneralPath(new Rectangle2D.Double(5.0, 5.0, 10.0, 10.0));
        this.setLocation(rand.nextInt(500), rand.nextInt(400));
    }

    public Vertex getVertex() {
        return (Vertex)this.component;
    }

    public void setGeneralPath(GeneralPath path) {
        path.closePath();
        super.setGeneralPath(path);
        this.rescale();
    }

    public void setVertex(Vertex vertex) {
        this.component = vertex;
    }

    public boolean contains(double x, double y) {
        return this.drawpath.contains(x, y);
    }

    public void setLocation(int x, int y) {
        this.setLocationDelta((int)((double)x - this.drawpath.getBounds2D().getCenterX()), (int)((double)y - this.drawpath.getBounds2D().getCenterY()));
    }

    public void setLocation(double x, double y) {
        this.setLocationDelta(x - this.drawpath.getBounds2D().getCenterX(), y - this.drawpath.getBounds2D().getCenterY());
    }

    public void setLocationDelta(int dx, int dy) {
        AffineTransform transform = new AffineTransform();
        transform.translate(dx, dy);
        this.drawpath.transform(transform);
    }

    public void setLocationDelta(double dx, double dy) {
        AffineTransform transform = new AffineTransform();
        transform.translate(dx, dy);
        this.drawpath.transform(transform);
    }

    public String toString() {
        return this.getLabel();
    }

    public void paint(Graphics2D g2d) {
        this.painter.paint(this, g2d);
    }

    public void rescale() {
        ((VisualVertexPainter)this.painter).rescale(this);
    }
}

