/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.neighborhood.HashedVector;
import org.apache.mahout.math.neighborhood.Searcher;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.RandomProjector;
import org.apache.mahout.math.random.WeightedThing;
import org.apache.mahout.math.stats.OnlineSummarizer;

public class LocalitySensitiveHashSearch
extends UpdatableSearcher {
    private static final int BITS = 64;
    private static final long BIT_MASK = -1L;
    private static final int MAX_HASH_LIMIT = 32;
    private static final int MIN_DISTRIBUTION_COUNT = 10;
    private final Multiset<HashedVector> trainingVectors = HashMultiset.create();
    private Matrix projection;
    private int searchSize;
    private double hashLimitStrategy = 0.9;
    private int distanceEvaluations = 0;
    private boolean initialized = false;

    public LocalitySensitiveHashSearch(DistanceMeasure distanceMeasure, int searchSize) {
        super(distanceMeasure);
        this.searchSize = searchSize;
        this.projection = null;
    }

    private void initialize(int numDimensions) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.projection = RandomProjector.generateBasisNormal(64, numDimensions);
    }

    private PriorityQueue<WeightedThing<Vector>> searchInternal(Vector query) {
        long queryHash = HashedVector.computeHash64(query, this.projection);
        PriorityQueue<WeightedThing<Vector>> top = Searcher.getCandidateQueue(this.getSearchSize());
        OnlineSummarizer[] distribution = new OnlineSummarizer[65];
        for (int i = 0; i < 65; ++i) {
            distribution[i] = new OnlineSummarizer();
        }
        this.distanceEvaluations = 0;
        int[] hashCounts = new int[65];
        int hashLimit = 64;
        int limitCount = 0;
        double distanceLimit = Double.POSITIVE_INFINITY;
        for (HashedVector vector : this.trainingVectors) {
            int bitDot = vector.hammingDistance(queryHash);
            if (bitDot > hashLimit) continue;
            ++this.distanceEvaluations;
            double distance = this.distanceMeasure.distance(query, vector);
            distribution[bitDot].add(distance);
            if (!(distance < distanceLimit)) continue;
            top.insertWithOverflow(new WeightedThing<HashedVector>(vector, distance));
            if (top.size() == this.searchSize) {
                distanceLimit = top.top().getWeight();
            }
            int n = bitDot;
            hashCounts[n] = hashCounts[n] + 1;
            ++limitCount;
            while (hashLimit > 0 && limitCount - hashCounts[hashLimit - 1] > this.searchSize) {
                limitCount -= hashCounts[--hashLimit];
            }
            if (!(this.hashLimitStrategy >= 0.0)) continue;
            while (hashLimit < 32 && distribution[hashLimit].getCount() > 10 && (1.0 - this.hashLimitStrategy) * distribution[hashLimit].getQuartile(0) + this.hashLimitStrategy * distribution[hashLimit].getQuartile(1) < distanceLimit) {
                limitCount += hashCounts[hashLimit];
                ++hashLimit;
            }
        }
        return top;
    }

    @Override
    public List<WeightedThing<Vector>> search(Vector query, int limit) {
        PriorityQueue<WeightedThing<Vector>> top = this.searchInternal(query);
        List<WeightedThing<Vector>> results = Lists.newArrayListWithExpectedSize(top.size());
        while (top.size() != 0) {
            WeightedThing<Vector> wv = top.pop();
            results.add(new WeightedThing<Vector>(((HashedVector)wv.getValue()).getVector(), wv.getWeight()));
        }
        Collections.reverse(results);
        if (limit < results.size()) {
            results = results.subList(0, limit);
        }
        return results;
    }

    @Override
    public WeightedThing<Vector> searchFirst(Vector query, boolean differentThanQuery) {
        PriorityQueue<WeightedThing<Vector>> top = this.searchInternal(query);
        while (top.size() > 2) {
            top.pop();
        }
        if (top.size() < 2) {
            return LocalitySensitiveHashSearch.removeHash(top.pop());
        }
        WeightedThing<Vector> secondBest = top.pop();
        WeightedThing<Vector> best = top.pop();
        if (differentThanQuery && best.getValue().equals(query)) {
            best = secondBest;
        }
        return LocalitySensitiveHashSearch.removeHash(best);
    }

    protected static WeightedThing<Vector> removeHash(WeightedThing<Vector> input) {
        return new WeightedThing<Vector>(((HashedVector)input.getValue()).getVector(), input.getWeight());
    }

    @Override
    public void add(Vector vector) {
        this.initialize(vector.size());
        this.trainingVectors.add(new HashedVector(vector, this.projection, -1, -1L));
    }

    @Override
    public int size() {
        return this.trainingVectors.size();
    }

    public int getSearchSize() {
        return this.searchSize;
    }

    public void setSearchSize(int size) {
        this.searchSize = size;
    }

    public void setRaiseHashLimitStrategy(double strategy) {
        this.hashLimitStrategy = strategy;
    }

    public int resetEvaluationCount() {
        int result = this.distanceEvaluations;
        this.distanceEvaluations = 0;
        return result;
    }

    @Override
    public Iterator<Vector> iterator() {
        return Iterators.transform(this.trainingVectors.iterator(), new Function<HashedVector, Vector>(){

            @Override
            public Vector apply(HashedVector input) {
                Preconditions.checkNotNull(input);
                return input.getVector();
            }
        });
    }

    @Override
    public boolean remove(Vector v, double epsilon) {
        return this.trainingVectors.remove(new HashedVector(v, this.projection, -1, -1L));
    }

    @Override
    public void clear() {
        this.trainingVectors.clear();
    }
}

