/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.naivebayes.BayesUtils;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public class IndexInstancesMapper
extends Mapper<Text, VectorWritable, IntWritable, VectorWritable> {
    private static final Pattern SLASH = Pattern.compile("/");
    private OpenObjectIntHashMap<String> labelIndex;

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        super.setup(ctx);
        this.labelIndex = BayesUtils.readIndexFromCache(ctx.getConfiguration());
    }

    protected void map(Text labelText, VectorWritable instance, Mapper.Context ctx) throws IOException, InterruptedException {
        String label = SLASH.split(labelText.toString())[1];
        if (this.labelIndex.containsKey(label)) {
            ctx.write((Object)new IntWritable(this.labelIndex.get(label)), (Object)instance);
        } else {
            ctx.getCounter((Enum)Counter.SKIPPED_INSTANCES).increment(1L);
        }
    }

    public static enum Counter {
        SKIPPED_INSTANCES;

    }
}

