/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import org.apache.mahout.classifier.AbstractVectorClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.math.Vector;

public abstract class AbstractNaiveBayesClassifier
extends AbstractVectorClassifier {
    private final NaiveBayesModel model;

    protected AbstractNaiveBayesClassifier(NaiveBayesModel model) {
        this.model = model;
    }

    protected NaiveBayesModel getModel() {
        return this.model;
    }

    protected abstract double getScoreForLabelFeature(int var1, int var2);

    protected double getScoreForLabelInstance(int label, Vector instance) {
        double result = 0.0;
        for (Vector.Element e : instance.nonZeroes()) {
            result += e.get() * this.getScoreForLabelFeature(label, e.index());
        }
        return result;
    }

    @Override
    public int numCategories() {
        return this.model.numLabels();
    }

    @Override
    public Vector classifyFull(Vector instance) {
        return this.classifyFull(this.model.createScoringVector(), instance);
    }

    @Override
    public Vector classifyFull(Vector r, Vector instance) {
        for (int label = 0; label < this.model.numLabels(); ++label) {
            r.setQuick(label, this.getScoreForLabelInstance(label, instance));
        }
        return r;
    }

    @Override
    public double classifyScalar(Vector instance) {
        throw new UnsupportedOperationException("Not supported in Naive Bayes");
    }

    @Override
    public Vector classify(Vector instance) {
        throw new UnsupportedOperationException("probabilites not supported in Naive Bayes");
    }
}

