/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.tools;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.classifier.df.tools.FrequenciesJob;
import org.apache.mahout.common.CommandLineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Frequencies
extends Configured
implements Tool {
    private static final Logger log = LoggerFactory.getLogger(Frequencies.class);

    private Frequencies() {
    }

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption dataOpt = obuilder.withLongName("data").withShortName("d").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).withMaximum(1).create()).withDescription("Data path").create();
        DefaultOption datasetOpt = obuilder.withLongName("dataset").withShortName("ds").withRequired(true).withArgument(abuilder.withName("path").withMinimum(1).create()).withDescription("dataset path").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption(dataOpt).withOption(datasetOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp(group);
                return 0;
            }
            String dataPath = cmdLine.getValue(dataOpt).toString();
            String datasetPath = cmdLine.getValue(datasetOpt).toString();
            log.debug("Data path : {}", (Object)dataPath);
            log.debug("Dataset path : {}", (Object)datasetPath);
            this.runTool(dataPath, datasetPath);
        }
        catch (OptionException e) {
            log.warn(e.toString(), e);
            CommandLineUtil.printHelp(group);
        }
        return 0;
    }

    private void runTool(String data, String dataset) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path workingDir = fs.getWorkingDirectory();
        Path dataPath = new Path(data);
        Path datasetPath = new Path(dataset);
        log.info("Computing the frequencies...");
        FrequenciesJob job = new FrequenciesJob(new Path(workingDir, "output"), dataPath, datasetPath);
        int[][] counts = job.run(this.getConf());
        log.info("counts[partition][class]");
        for (int[] count : counts) {
            log.info(Arrays.toString(count));
        }
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new Frequencies(), (String[])args);
    }
}

