/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.partial;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.df.Bagging;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataConverter;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.mapreduce.Builder;
import org.apache.mahout.classifier.df.mapreduce.MapredMapper;
import org.apache.mahout.classifier.df.mapreduce.MapredOutput;
import org.apache.mahout.classifier.df.mapreduce.partial.TreeID;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Step1Mapper
extends MapredMapper<LongWritable, Text, TreeID, MapredOutput> {
    private static final Logger log = LoggerFactory.getLogger(Step1Mapper.class);
    private DataConverter converter;
    private Random rng;
    private int nbTrees;
    private int firstTreeId;
    private int partition;
    private final List<Instance> instances = Lists.newArrayList();

    public int getFirstTreeId() {
        return this.firstTreeId;
    }

    @Override
    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.configure(Builder.getRandomSeed(conf), conf.getInt("mapred.task.partition", -1), Builder.getNumMaps(conf), Builder.getNbTrees(conf));
    }

    protected void configure(Long seed, int partition, int numMapTasks, int numTrees) {
        this.converter = new DataConverter(this.getDataset());
        log.debug("seed : {}", (Object)seed);
        this.rng = seed == null ? RandomUtils.getRandom() : RandomUtils.getRandom(seed);
        Preconditions.checkArgument(partition >= 0, "Wrong partition ID: " + partition + ". Partition must be >= 0!");
        this.partition = partition;
        this.nbTrees = Step1Mapper.nbTrees(numMapTasks, numTrees, partition);
        this.firstTreeId = 0;
        for (int p = 0; p < partition; ++p) {
            this.firstTreeId += Step1Mapper.nbTrees(numMapTasks, numTrees, p);
        }
        log.debug("partition : {}", (Object)partition);
        log.debug("nbTrees : {}", (Object)this.nbTrees);
        log.debug("firstTreeId : {}", (Object)this.firstTreeId);
    }

    public static int nbTrees(int numMaps, int numTrees, int partition) {
        int nbTrees = numTrees / numMaps;
        if (partition == 0) {
            nbTrees += numTrees - nbTrees * numMaps;
        }
        return nbTrees;
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.instances.add(this.converter.convert(value.toString()));
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        log.debug("partition: {} numInstances: {}", (Object)this.partition, (Object)this.instances.size());
        Data data = new Data(this.getDataset(), this.instances);
        Bagging bagging = new Bagging(this.getTreeBuilder(), data);
        TreeID key = new TreeID();
        log.debug("Building {} trees", (Object)this.nbTrees);
        for (int treeId = 0; treeId < this.nbTrees; ++treeId) {
            log.debug("Building tree number : {}", (Object)treeId);
            Node tree = bagging.build(this.rng);
            key.set(this.partition, this.firstTreeId + treeId);
            if (!this.isOutput()) continue;
            MapredOutput emOut = new MapredOutput(tree);
            context.write((Object)key, (Object)emOut);
        }
    }
}

