/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.eval.DataModelBuilder;
import org.apache.mahout.cf.taste.eval.IRStatistics;
import org.apache.mahout.cf.taste.eval.RecommenderBuilder;
import org.apache.mahout.cf.taste.eval.RecommenderIRStatsEvaluator;
import org.apache.mahout.cf.taste.eval.RelevantItemsDataSplitter;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.eval.GenericRelevantItemsDataSplitter;
import org.apache.mahout.cf.taste.impl.eval.IRStatisticsImpl;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericRecommenderIRStatsEvaluator
implements RecommenderIRStatsEvaluator {
    private static final Logger log = LoggerFactory.getLogger(GenericRecommenderIRStatsEvaluator.class);
    private static final double LOG2 = Math.log(2.0);
    public static final double CHOOSE_THRESHOLD = Double.NaN;
    private final Random random;
    private final RelevantItemsDataSplitter dataSplitter;

    public GenericRecommenderIRStatsEvaluator() {
        this(new GenericRelevantItemsDataSplitter());
    }

    public GenericRecommenderIRStatsEvaluator(RelevantItemsDataSplitter dataSplitter) {
        Preconditions.checkNotNull(dataSplitter);
        this.random = RandomUtils.getRandom();
        this.dataSplitter = dataSplitter;
    }

    @Override
    public IRStatistics evaluate(RecommenderBuilder recommenderBuilder, DataModelBuilder dataModelBuilder, DataModel dataModel, IDRescorer rescorer, int at, double relevanceThreshold, double evaluationPercentage) throws TasteException {
        Preconditions.checkArgument(recommenderBuilder != null, "recommenderBuilder is null");
        Preconditions.checkArgument(dataModel != null, "dataModel is null");
        Preconditions.checkArgument(at >= 1, "at must be at least 1");
        Preconditions.checkArgument(evaluationPercentage > 0.0 && evaluationPercentage <= 1.0, "Invalid evaluationPercentage: " + evaluationPercentage + ". Must be: 0.0 < evaluationPercentage <= 1.0");
        int numItems = dataModel.getNumItems();
        FullRunningAverage precision = new FullRunningAverage();
        FullRunningAverage recall = new FullRunningAverage();
        FullRunningAverage fallOut = new FullRunningAverage();
        FullRunningAverage nDCG = new FullRunningAverage();
        int numUsersRecommendedFor = 0;
        int numUsersWithRecommendations = 0;
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            if (this.random.nextDouble() >= evaluationPercentage) continue;
            long start = System.currentTimeMillis();
            PreferenceArray prefs = dataModel.getPreferencesFromUser(userID);
            double theRelevanceThreshold = Double.isNaN(relevanceThreshold) ? GenericRecommenderIRStatsEvaluator.computeThreshold(prefs) : relevanceThreshold;
            FastIDSet relevantItemIDs = this.dataSplitter.getRelevantItemsIDs(userID, at, theRelevanceThreshold, dataModel);
            int numRelevantItems = relevantItemIDs.size();
            if (numRelevantItems <= 0) continue;
            FastByIDMap<PreferenceArray> trainingUsers = new FastByIDMap<PreferenceArray>(dataModel.getNumUsers());
            LongPrimitiveIterator it2 = dataModel.getUserIDs();
            while (it2.hasNext()) {
                this.dataSplitter.processOtherUser(userID, relevantItemIDs, trainingUsers, it2.nextLong(), dataModel);
            }
            DataModel trainingModel = dataModelBuilder == null ? new GenericDataModel(trainingUsers) : dataModelBuilder.buildDataModel(trainingUsers);
            try {
                trainingModel.getPreferencesFromUser(userID);
            }
            catch (NoSuchUserException nsee) {
                continue;
            }
            int size = numRelevantItems + trainingModel.getItemIDsFromUser(userID).size();
            if (size < 2 * at) continue;
            Recommender recommender = recommenderBuilder.buildRecommender(trainingModel);
            int intersectionSize = 0;
            List<RecommendedItem> recommendedItems = recommender.recommend(userID, at, rescorer);
            for (RecommendedItem recommendedItem : recommendedItems) {
                if (!relevantItemIDs.contains(recommendedItem.getItemID())) continue;
                ++intersectionSize;
            }
            int numRecommendedItems = recommendedItems.size();
            if (numRecommendedItems > 0) {
                precision.addDatum((double)intersectionSize / (double)numRecommendedItems);
            }
            recall.addDatum((double)intersectionSize / (double)numRelevantItems);
            if (numRelevantItems < size) {
                fallOut.addDatum((double)(numRecommendedItems - intersectionSize) / (double)(numItems - numRelevantItems));
            }
            double cumulativeGain = 0.0;
            double idealizedGain = 0.0;
            for (int i = 0; i < numRecommendedItems; ++i) {
                RecommendedItem item = recommendedItems.get(i);
                double discount = 1.0 / GenericRecommenderIRStatsEvaluator.log2((double)i + 2.0);
                if (relevantItemIDs.contains(item.getItemID())) {
                    cumulativeGain += discount;
                }
                if (i >= numRelevantItems) continue;
                idealizedGain += discount;
            }
            if (idealizedGain > 0.0) {
                nDCG.addDatum(cumulativeGain / idealizedGain);
            }
            ++numUsersRecommendedFor;
            if (numRecommendedItems > 0) {
                ++numUsersWithRecommendations;
            }
            long end = System.currentTimeMillis();
            log.info("Evaluated with user {} in {}ms", (Object)userID, (Object)(end - start));
            log.info("Precision/recall/fall-out/nDCG/reach: {} / {} / {} / {} / {}", precision.getAverage(), recall.getAverage(), fallOut.getAverage(), nDCG.getAverage(), (double)numUsersWithRecommendations / (double)numUsersRecommendedFor);
        }
        return new IRStatisticsImpl(precision.getAverage(), recall.getAverage(), fallOut.getAverage(), nDCG.getAverage(), (double)numUsersWithRecommendations / (double)numUsersRecommendedFor);
    }

    private static double computeThreshold(PreferenceArray prefs) {
        if (prefs.length() < 2) {
            return Double.NEGATIVE_INFINITY;
        }
        FullRunningAverageAndStdDev stdDev = new FullRunningAverageAndStdDev();
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            stdDev.addDatum(prefs.getValue(i));
        }
        return stdDev.getAverage() + stdDev.getStandardDeviation();
    }

    private static double log2(double value) {
        return Math.log(value) / LOG2;
    }
}

