/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.common.InvertedRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.WeightedRunningAverage;

public final class WeightedRunningAverageAndStdDev
extends WeightedRunningAverage
implements RunningAverageAndStdDev {
    private double totalSquaredWeight = 0.0;
    private double totalWeightedData = 0.0;
    private double totalWeightedSquaredData = 0.0;

    @Override
    public synchronized void addDatum(double datum, double weight) {
        super.addDatum(datum, weight);
        this.totalSquaredWeight += weight * weight;
        double weightedData = datum * weight;
        this.totalWeightedData += weightedData;
        this.totalWeightedSquaredData += weightedData * datum;
    }

    @Override
    public synchronized void removeDatum(double datum, double weight) {
        super.removeDatum(datum, weight);
        this.totalSquaredWeight -= weight * weight;
        if (this.totalSquaredWeight <= 0.0) {
            this.totalSquaredWeight = 0.0;
        }
        double weightedData = datum * weight;
        this.totalWeightedData -= weightedData;
        if (this.totalWeightedData <= 0.0) {
            this.totalWeightedData = 0.0;
        }
        this.totalWeightedSquaredData -= weightedData * datum;
        if (this.totalWeightedSquaredData <= 0.0) {
            this.totalWeightedSquaredData = 0.0;
        }
    }

    @Override
    public synchronized void changeDatum(double delta, double weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized double getStandardDeviation() {
        double totalWeight = this.getTotalWeight();
        return Math.sqrt((this.totalWeightedSquaredData * totalWeight - this.totalWeightedData * this.totalWeightedData) / (totalWeight * totalWeight - this.totalSquaredWeight));
    }

    @Override
    public RunningAverageAndStdDev inverse() {
        return new InvertedRunningAverageAndStdDev(this);
    }

    @Override
    public synchronized String toString() {
        return String.valueOf(String.valueOf(this.getAverage()) + ',' + this.getStandardDeviation());
    }
}

