/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.als.ALS;
import org.apache.mahout.cf.taste.hadoop.als.ParallelALSFactorizationJob;
import org.apache.mahout.cf.taste.hadoop.als.SharingMapper;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.als.ImplicitFeedbackAlternatingLeastSquaresSolver;

public class SolveImplicitFeedbackMapper
extends SharingMapper<IntWritable, VectorWritable, IntWritable, VectorWritable, ImplicitFeedbackAlternatingLeastSquaresSolver> {
    private final VectorWritable uiOrmj = new VectorWritable();

    @Override
    ImplicitFeedbackAlternatingLeastSquaresSolver createSharedInstance(Mapper.Context ctx) throws IOException {
        Configuration conf = ctx.getConfiguration();
        double lambda = Double.parseDouble(conf.get(ParallelALSFactorizationJob.LAMBDA));
        double alpha = Double.parseDouble(conf.get(ParallelALSFactorizationJob.ALPHA));
        int numFeatures = conf.getInt(ParallelALSFactorizationJob.NUM_FEATURES, -1);
        int numEntities = Integer.parseInt(conf.get(ParallelALSFactorizationJob.NUM_ENTITIES));
        Preconditions.checkArgument(numFeatures > 0, "numFeatures must be greater then 0!");
        return new ImplicitFeedbackAlternatingLeastSquaresSolver(numFeatures, lambda, alpha, ALS.readMatrixByRowsFromDistributedCache(numEntities, conf));
    }

    protected void map(IntWritable userOrItemID, VectorWritable ratingsWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        ImplicitFeedbackAlternatingLeastSquaresSolver solver = (ImplicitFeedbackAlternatingLeastSquaresSolver)this.getSharedInstance();
        this.uiOrmj.set(solver.solve(ratingsWritable.get()));
        ctx.write((Object)userOrItemID, (Object)this.uiOrmj);
    }
}

