/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;

public class UJob {
    private static final String OUTPUT_U = "u";
    private static final String PROP_UHAT_PATH = "ssvd.uhat.path";
    private static final String PROP_SIGMA_PATH = "ssvd.sigma.path";
    private static final String PROP_OUTPUT_SCALING = "ssvd.u.output.scaling";
    private static final String PROP_K = "ssvd.k";
    private Job job;

    public void run(Configuration conf, Path inputPathQ, Path inputUHatPath, Path sigmaPath, Path outputPath, int k, int numReduceTasks, Class<? extends Writable> labelClass, SSVDSolver.OutputScalingEnum outputScaling) throws ClassNotFoundException, InterruptedException, IOException {
        this.job = new Job(conf);
        this.job.setJobName("U-job");
        this.job.setJarByClass(UJob.class);
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{inputPathQ});
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outputPath);
        this.job.getConfiguration().set("mapreduce.output.basename", OUTPUT_U);
        FileOutputFormat.setCompressOutput((Job)this.job, (boolean)true);
        FileOutputFormat.setOutputCompressorClass((Job)this.job, DefaultCodec.class);
        SequenceFileOutputFormat.setOutputCompressionType((Job)this.job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        this.job.setMapperClass(UMapper.class);
        this.job.setMapOutputKeyClass(IntWritable.class);
        this.job.setMapOutputValueClass(VectorWritable.class);
        this.job.setOutputKeyClass(labelClass);
        this.job.setOutputValueClass(VectorWritable.class);
        this.job.getConfiguration().set(PROP_UHAT_PATH, inputUHatPath.toString());
        this.job.getConfiguration().set(PROP_SIGMA_PATH, sigmaPath.toString());
        this.job.getConfiguration().set(PROP_OUTPUT_SCALING, outputScaling.name());
        this.job.getConfiguration().setInt(PROP_K, k);
        this.job.setNumReduceTasks(0);
        this.job.submit();
    }

    public void waitForCompletion() throws IOException, ClassNotFoundException, InterruptedException {
        this.job.waitForCompletion(false);
        if (!this.job.isSuccessful()) {
            throw new IOException("U job unsuccessful.");
        }
    }

    public static final class UMapper
    extends Mapper<Writable, VectorWritable, Writable, VectorWritable> {
        private Matrix uHat;
        private DenseVector uRow;
        private VectorWritable uRowWritable;
        private int kp;
        private int k;
        private Vector sValues;

        protected void map(Writable key, VectorWritable value, Mapper.Context context) throws IOException, InterruptedException {
            Vector qRow = value.get();
            if (this.sValues != null) {
                for (int i = 0; i < this.k; ++i) {
                    this.uRow.setQuick(i, qRow.dot(this.uHat.viewColumn(i)) * this.sValues.getQuick(i));
                }
            } else {
                for (int i = 0; i < this.k; ++i) {
                    this.uRow.setQuick(i, qRow.dot(this.uHat.viewColumn(i)));
                }
            }
            if (qRow instanceof NamedVector) {
                this.uRowWritable.set((Vector)new NamedVector((Vector)this.uRow, ((NamedVector)qRow).getName()));
            } else {
                this.uRowWritable.set((Vector)this.uRow);
            }
            context.write((Object)key, (Object)this.uRowWritable);
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Path uHatPath = new Path(context.getConfiguration().get(UJob.PROP_UHAT_PATH));
            Path sigmaPath = new Path(context.getConfiguration().get(UJob.PROP_SIGMA_PATH));
            FileSystem fs = FileSystem.get((URI)uHatPath.toUri(), (Configuration)context.getConfiguration());
            this.uHat = SSVDHelper.drmLoadAsDense(fs, uHatPath, context.getConfiguration());
            this.kp = this.uHat.columnSize();
            this.k = context.getConfiguration().getInt(UJob.PROP_K, this.kp);
            this.uRow = new DenseVector(this.k);
            this.uRowWritable = new VectorWritable((Vector)this.uRow);
            SSVDSolver.OutputScalingEnum outputScaling = SSVDSolver.OutputScalingEnum.valueOf(context.getConfiguration().get(UJob.PROP_OUTPUT_SCALING));
            switch (outputScaling) {
                case SIGMA: {
                    this.sValues = SSVDHelper.loadVector(sigmaPath, context.getConfiguration());
                    break;
                }
                case HALFSIGMA: {
                    this.sValues = SSVDHelper.loadVector(sigmaPath, context.getConfiguration());
                    this.sValues.assign(Functions.SQRT);
                    break;
                }
            }
        }
    }
}

