/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.fpm.pfpgrowth.TransactionTreeIterator;
import org.apache.mahout.math.list.IntArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionTree
implements Writable,
Iterable<Pair<IntArrayList, Long>> {
    private static final Logger log = LoggerFactory.getLogger(TransactionTree.class);
    private static final int DEFAULT_CHILDREN_INITIAL_SIZE = 2;
    private static final int DEFAULT_INITIAL_SIZE = 8;
    private static final float GROWTH_RATE = 1.5f;
    private static final int ROOTNODEID = 0;
    private int[] attribute;
    private int[] childCount;
    private int[][] nodeChildren;
    private long[] nodeCount;
    private int nodes;
    private boolean representedAsList;
    private List<Pair<IntArrayList, Long>> transactionSet;

    public TransactionTree() {
        this(8);
    }

    public TransactionTree(int size) {
        if (size < 8) {
            size = 8;
        }
        this.childCount = new int[size];
        this.attribute = new int[size];
        this.nodeCount = new long[size];
        this.nodeChildren = new int[size][];
        this.createRootNode();
        this.representedAsList = false;
    }

    public TransactionTree(IntArrayList items, Long support) {
        this.representedAsList = true;
        this.transactionSet = Lists.newArrayList();
        this.transactionSet.add(new Pair<IntArrayList, Long>(items, support));
    }

    public TransactionTree(List<Pair<IntArrayList, Long>> transactionSet) {
        this.representedAsList = true;
        this.transactionSet = transactionSet;
    }

    public void addChild(int parentNodeId, int childnodeId) {
        int length = this.childCount[parentNodeId];
        if (length >= this.nodeChildren[parentNodeId].length) {
            this.resizeChildren(parentNodeId);
        }
        this.nodeChildren[parentNodeId][length++] = childnodeId;
        this.childCount[parentNodeId] = length;
    }

    public void addCount(int nodeId, long nextNodeCount) {
        if (nodeId < this.nodes) {
            int n = nodeId;
            this.nodeCount[n] = this.nodeCount[n] + nextNodeCount;
        }
    }

    public int addPattern(IntArrayList myList, long addCount) {
        int temp = 0;
        int ret = 0;
        boolean addCountMode = true;
        for (int idx = 0; idx < myList.size(); ++idx) {
            int child;
            int attributeValue = myList.get(idx);
            if (addCountMode) {
                child = this.childWithAttribute(temp, attributeValue);
                if (child == -1) {
                    addCountMode = false;
                } else {
                    this.addCount(child, addCount);
                    temp = child;
                }
            }
            if (addCountMode) continue;
            temp = child = this.createNode(temp, attributeValue, addCount);
            ++ret;
        }
        return ret;
    }

    public int attribute(int nodeId) {
        return this.attribute[nodeId];
    }

    public int childAtIndex(int nodeId, int index) {
        if (this.childCount[nodeId] < index) {
            return -1;
        }
        return this.nodeChildren[nodeId][index];
    }

    public int childCount() {
        int sum = 0;
        for (int i = 0; i < this.nodes; ++i) {
            sum += this.childCount[i];
        }
        return sum;
    }

    public int childCount(int nodeId) {
        return this.childCount[nodeId];
    }

    public int childWithAttribute(int nodeId, int childAttribute) {
        int length = this.childCount[nodeId];
        for (int i = 0; i < length; ++i) {
            if (this.attribute[this.nodeChildren[nodeId][i]] != childAttribute) continue;
            return this.nodeChildren[nodeId][i];
        }
        return -1;
    }

    public long count(int nodeId) {
        return this.nodeCount[nodeId];
    }

    public Map<Integer, MutableLong> generateFList() {
        HashMap frequencyList = Maps.newHashMap();
        for (Pair<IntArrayList, Long> p : this) {
            IntArrayList items = p.getFirst();
            for (int idx = 0; idx < items.size(); ++idx) {
                if (!frequencyList.containsKey(items.get(idx))) {
                    frequencyList.put(items.get(idx), new MutableLong(0L));
                }
                ((MutableLong)frequencyList.get(items.get(idx))).add((Number)p.getSecond());
            }
        }
        return frequencyList;
    }

    public TransactionTree getCompressedTree() {
        TransactionTree ctree = new TransactionTree();
        Iterator<Pair<IntArrayList, Long>> it = this.iterator();
        int node = 0;
        int size = 0;
        ArrayList compressedTransactionSet = Lists.newArrayList();
        while (it.hasNext()) {
            Pair<IntArrayList, Long> p = it.next();
            p.getFirst().sort();
            compressedTransactionSet.add(p);
            node += ctree.addPattern(p.getFirst(), p.getSecond());
            size += p.getFirst().size() + 2;
        }
        if (log.isDebugEnabled()) {
            log.debug("Nodes in UnCompressed Tree: {} ", (Object)this.nodes);
            log.debug("UnCompressed Tree Size: {}", (Object)((double)(this.nodes * 4 * 4 + this.childCount() * 4) / 1000000.0));
            log.debug("Nodes in Compressed Tree: {} ", (Object)node);
            log.debug("Compressed Tree Size: {}", (Object)((double)(node * 4 * 4 + ctree.childCount() * 4) / 1000000.0));
            log.debug("TransactionSet Size: {}", (Object)((double)(size * 4) / 1000000.0));
        }
        if (node * 4 * 4 + ctree.childCount() * 4 <= size * 4) {
            return ctree;
        }
        return new TransactionTree(compressedTransactionSet);
    }

    @Override
    public Iterator<Pair<IntArrayList, Long>> iterator() {
        if (this.isTreeEmpty() && !this.representedAsList) {
            throw new IllegalStateException("This is a bug. Please report this to mahout-user list");
        }
        if (this.representedAsList) {
            return this.transactionSet.iterator();
        }
        return new TransactionTreeIterator(this);
    }

    public boolean isTreeEmpty() {
        return this.nodes <= 1;
    }

    public void readFields(DataInput in) throws IOException {
        this.representedAsList = in.readBoolean();
        VIntWritable vInt = new VIntWritable();
        VLongWritable vLong = new VLongWritable();
        if (this.representedAsList) {
            this.transactionSet = Lists.newArrayList();
            vInt.readFields(in);
            int numTransactions = vInt.get();
            for (int i = 0; i < numTransactions; ++i) {
                vLong.readFields(in);
                Long support = vLong.get();
                vInt.readFields(in);
                int length = vInt.get();
                int[] items = new int[length];
                for (int j = 0; j < length; ++j) {
                    vInt.readFields(in);
                    items[j] = vInt.get();
                }
                Pair<IntArrayList, Long> transaction = new Pair<IntArrayList, Long>(new IntArrayList(items), support);
                this.transactionSet.add(transaction);
            }
        } else {
            vInt.readFields(in);
            this.nodes = vInt.get();
            this.attribute = new int[this.nodes];
            this.nodeCount = new long[this.nodes];
            this.childCount = new int[this.nodes];
            this.nodeChildren = new int[this.nodes][];
            for (int i = 0; i < this.nodes; ++i) {
                int childCountI;
                vInt.readFields(in);
                this.attribute[i] = vInt.get();
                vLong.readFields(in);
                this.nodeCount[i] = vLong.get();
                vInt.readFields(in);
                this.childCount[i] = childCountI = vInt.get();
                this.nodeChildren[i] = new int[childCountI];
                for (int j = 0; j < childCountI; ++j) {
                    vInt.readFields(in);
                    this.nodeChildren[i][j] = vInt.get();
                }
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.representedAsList);
        VIntWritable vInt = new VIntWritable();
        VLongWritable vLong = new VLongWritable();
        if (this.representedAsList) {
            int transactionSetSize = this.transactionSet.size();
            vInt.set(transactionSetSize);
            vInt.write(out);
            for (Pair<IntArrayList, Long> transaction : this.transactionSet) {
                vLong.set(transaction.getSecond().longValue());
                vLong.write(out);
                vInt.set(transaction.getFirst().size());
                vInt.write(out);
                IntArrayList items = transaction.getFirst();
                for (int idx = 0; idx < items.size(); ++idx) {
                    int item = items.get(idx);
                    vInt.set(item);
                    vInt.write(out);
                }
            }
        } else {
            vInt.set(this.nodes);
            vInt.write(out);
            for (int i = 0; i < this.nodes; ++i) {
                vInt.set(this.attribute[i]);
                vInt.write(out);
                vLong.set(this.nodeCount[i]);
                vLong.write(out);
                vInt.set(this.childCount[i]);
                vInt.write(out);
                int max = this.childCount[i];
                for (int j = 0; j < max; ++j) {
                    vInt.set(this.nodeChildren[i][j]);
                    vInt.write(out);
                }
            }
        }
    }

    private int createNode(int parentNodeId, int attributeValue, long count) {
        if (this.nodes >= this.attribute.length) {
            this.resize();
        }
        this.childCount[this.nodes] = 0;
        this.attribute[this.nodes] = attributeValue;
        this.nodeCount[this.nodes] = count;
        if (this.nodeChildren[this.nodes] == null) {
            this.nodeChildren[this.nodes] = new int[2];
        }
        int childNodeId = this.nodes++;
        this.addChild(parentNodeId, childNodeId);
        return childNodeId;
    }

    private void createRootNode() {
        this.childCount[this.nodes] = 0;
        this.attribute[this.nodes] = -1;
        this.nodeCount[this.nodes] = 0L;
        if (this.nodeChildren[this.nodes] == null) {
            this.nodeChildren[this.nodes] = new int[2];
        }
        ++this.nodes;
    }

    private void resize() {
        int size = (int)(1.5f * (float)this.nodes);
        if (size < 8) {
            size = 8;
        }
        int[] oldChildCount = this.childCount;
        int[] oldAttribute = this.attribute;
        long[] oldnodeCount = this.nodeCount;
        int[][] oldNodeChildren = this.nodeChildren;
        this.childCount = new int[size];
        this.attribute = new int[size];
        this.nodeCount = new long[size];
        this.nodeChildren = new int[size][];
        System.arraycopy(oldChildCount, 0, this.childCount, 0, this.nodes);
        System.arraycopy(oldAttribute, 0, this.attribute, 0, this.nodes);
        System.arraycopy(oldnodeCount, 0, this.nodeCount, 0, this.nodes);
        System.arraycopy(oldNodeChildren, 0, this.nodeChildren, 0, this.nodes);
    }

    private void resizeChildren(int nodeId) {
        int length = this.childCount[nodeId];
        int size = (int)(1.5f * (float)length);
        if (size < 2) {
            size = 2;
        }
        int[] oldNodeChildren = this.nodeChildren[nodeId];
        this.nodeChildren[nodeId] = new int[size];
        System.arraycopy(oldNodeChildren, 0, this.nodeChildren[nodeId], 0, length);
    }
}

