/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorizer;
import org.apache.mahout.cf.taste.impl.recommender.svd.NoPersistenceStrategy;
import org.apache.mahout.cf.taste.impl.recommender.svd.PersistenceStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SVDRecommender
extends AbstractRecommender {
    private Factorization factorization;
    private final Factorizer factorizer;
    private final PersistenceStrategy persistenceStrategy;
    private final RefreshHelper refreshHelper;
    private static final Logger log = LoggerFactory.getLogger(SVDRecommender.class);

    public SVDRecommender(DataModel dataModel, Factorizer factorizer) throws TasteException {
        this(dataModel, factorizer, SVDRecommender.getDefaultCandidateItemsStrategy(), SVDRecommender.getDefaultPersistenceStrategy());
    }

    public SVDRecommender(DataModel dataModel, Factorizer factorizer, CandidateItemsStrategy candidateItemsStrategy) throws TasteException {
        this(dataModel, factorizer, candidateItemsStrategy, SVDRecommender.getDefaultPersistenceStrategy());
    }

    public SVDRecommender(DataModel dataModel, Factorizer factorizer, PersistenceStrategy persistenceStrategy) throws TasteException {
        this(dataModel, factorizer, SVDRecommender.getDefaultCandidateItemsStrategy(), persistenceStrategy);
    }

    public SVDRecommender(DataModel dataModel, Factorizer factorizer, CandidateItemsStrategy candidateItemsStrategy, PersistenceStrategy persistenceStrategy) throws TasteException {
        super(dataModel, candidateItemsStrategy);
        this.factorizer = (Factorizer)Preconditions.checkNotNull((Object)factorizer);
        this.persistenceStrategy = (PersistenceStrategy)Preconditions.checkNotNull((Object)persistenceStrategy);
        try {
            this.factorization = persistenceStrategy.load();
        }
        catch (IOException e) {
            throw new TasteException("Error loading factorization", e);
        }
        if (this.factorization == null) {
            this.train();
        }
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                SVDRecommender.this.train();
                return null;
            }
        });
        this.refreshHelper.addDependency(this.getDataModel());
        this.refreshHelper.addDependency(factorizer);
        this.refreshHelper.addDependency(candidateItemsStrategy);
    }

    static PersistenceStrategy getDefaultPersistenceStrategy() {
        return new NoPersistenceStrategy();
    }

    private void train() throws TasteException {
        this.factorization = this.factorizer.factorize();
        try {
            this.persistenceStrategy.maybePersist(this.factorization);
        }
        catch (IOException e) {
            throw new TasteException("Error persisting factorization", e);
        }
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument((howMany >= 1 ? 1 : 0) != 0, (Object)"howMany must be at least 1");
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        PreferenceArray preferencesFromUser = this.getDataModel().getPreferencesFromUser(userID);
        FastIDSet possibleItemIDs = this.getAllOtherItems(userID, preferencesFromUser);
        List<RecommendedItem> topItems = TopItems.getTopItems(howMany, possibleItemIDs.iterator(), rescorer, new Estimator(userID));
        log.debug("Recommendations are: {}", topItems);
        return topItems;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        double[] userFeatures = this.factorization.getUserFeatures(userID);
        double[] itemFeatures = this.factorization.getItemFeatures(itemID);
        double estimate = 0.0;
        for (int feature = 0; feature < userFeatures.length; ++feature) {
            estimate += userFeatures[feature] * itemFeatures[feature];
        }
        return (float)estimate;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final long theUserID;

        private Estimator(long theUserID) {
            this.theUserID = theUserID;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            return SVDRecommender.this.estimatePreference(this.theUserID, itemID);
        }
    }
}

