/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.random.Sampler;

public class MultiNormal
implements Sampler<Vector> {
    private final Random gen = RandomUtils.getRandom();
    private final int dimension;
    private final Matrix scale;
    private final Vector mean;

    public MultiNormal(Vector diagonal) {
        this(new DiagonalMatrix(diagonal), null);
    }

    public MultiNormal(Vector diagonal, Vector mean) {
        this(new DiagonalMatrix(diagonal), mean);
    }

    public MultiNormal(Matrix a, Vector mean) {
        this(a, mean, a.columnSize());
    }

    public MultiNormal(int dimension) {
        this(null, null, dimension);
    }

    public MultiNormal(double radius, Vector mean) {
        this(new DiagonalMatrix(radius, mean.size()), mean);
    }

    private MultiNormal(Matrix scale, Vector mean, int dimension) {
        this.dimension = dimension;
        this.scale = scale;
        this.mean = mean;
    }

    @Override
    public Vector sample() {
        Vector v = new DenseVector(this.dimension).assign(new DoubleFunction(){

            @Override
            public double apply(double ignored) {
                return MultiNormal.this.gen.nextGaussian();
            }
        });
        if (this.mean != null) {
            if (this.scale != null) {
                return this.scale.times(v).plus(this.mean);
            }
            return v.plus(this.mean);
        }
        if (this.scale != null) {
            return this.scale.times(v);
        }
        return v;
    }

    public Vector getScale() {
        return this.mean;
    }
}

