/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.dataset;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.common.StringTuple;

public class KeyBasedStringTupleReducer
extends Reducer<Text, StringTuple, Text, Text> {
    private int maxTransactionLength = 100;

    protected void reduce(Text key, Iterable<StringTuple> values, Reducer.Context context) throws IOException, InterruptedException {
        HashSet items = Sets.newHashSet();
        for (StringTuple value : values) {
            for (String field : value.getEntries()) {
                items.add(field);
            }
        }
        if (items.size() > 1) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (String field : items) {
                if (i % this.maxTransactionLength == 0) {
                    if (i != 0) {
                        context.write(null, (Object)new Text(sb.toString()));
                    }
                    sb.replace(0, sb.length(), "");
                    sep = "";
                }
                sb.append(sep).append(field);
                sep = "\t";
                ++i;
            }
            if (sb.length() > 0) {
                context.write(null, (Object)new Text(sb.toString()));
            }
        }
    }

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("job.parameters", ""));
        this.maxTransactionLength = Integer.valueOf(params.get("maxTransactionLength", "100"));
    }
}

