/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.display;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.display.DisplayClustering;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class DisplayCanopy
extends DisplayClustering {
    DisplayCanopy() {
        this.initialize();
        this.setTitle("Canopy Clusters (>" + (int)(significance * 100.0) + "% of population)");
    }

    @Override
    public void paint(Graphics g) {
        DisplayCanopy.plotSampleData((Graphics2D)g);
        DisplayCanopy.plotClusters((Graphics2D)g);
    }

    protected static void plotClusters(Graphics2D g2) {
        int cx = CLUSTERS.size() - 1;
        for (List clusters : CLUSTERS) {
            for (Cluster cluster : clusters) {
                if (!DisplayCanopy.isSignificant(cluster)) continue;
                g2.setStroke(new BasicStroke(1.0f));
                g2.setColor(Color.BLUE);
                double[] t1 = new double[]{3.0, 3.0};
                DisplayCanopy.plotEllipse(g2, cluster.getCenter(), (Vector)new DenseVector(t1));
                double[] t2 = new double[]{2.8, 2.8};
                DisplayCanopy.plotEllipse(g2, cluster.getCenter(), (Vector)new DenseVector(t2));
                g2.setColor(COLORS[Math.min(DisplayClustering.COLORS.length - 1, cx)]);
                g2.setStroke(new BasicStroke(cx == 0 ? 3.0f : 1.0f));
                DisplayCanopy.plotEllipse(g2, cluster.getCenter(), cluster.getRadius().times(3.0));
            }
            --cx;
        }
    }

    public static void main(String[] args) throws Exception {
        Path samples = new Path("samples");
        Path output = new Path("output");
        Configuration conf = new Configuration();
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{samples});
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{output});
        RandomUtils.useTestSeed();
        DisplayCanopy.generateSamples();
        DisplayCanopy.writeSampleData(samples);
        CanopyDriver.buildClusters((Configuration)conf, (Path)samples, (Path)output, (DistanceMeasure)new ManhattanDistanceMeasure(), (double)3.0, (double)2.8, (int)0, (boolean)true);
        DisplayCanopy.loadClustersWritable(output);
        new DisplayCanopy();
    }
}

