/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.sgd.CsvRecordFactory;
import org.apache.mahout.classifier.sgd.L1;
import org.apache.mahout.classifier.sgd.OnlineLogisticRegression;
import org.apache.mahout.classifier.sgd.PriorFunction;

public class LogisticModelParameters
implements Writable {
    private String targetVariable;
    private Map<String, String> typeMap;
    private int numFeatures;
    private boolean useBias;
    private int maxTargetCategories;
    private List<String> targetCategories;
    private double lambda;
    private double learningRate;
    private CsvRecordFactory csv;
    private OnlineLogisticRegression lr;

    public CsvRecordFactory getCsvRecordFactory() {
        if (this.csv == null) {
            this.csv = new CsvRecordFactory(this.getTargetVariable(), this.getTypeMap()).maxTargetValue(this.getMaxTargetCategories()).includeBiasTerm(this.useBias());
            if (this.targetCategories != null) {
                this.csv.defineTargetCategories(this.targetCategories);
            }
        }
        return this.csv;
    }

    public OnlineLogisticRegression createRegression() {
        if (this.lr == null) {
            this.lr = new OnlineLogisticRegression(this.getMaxTargetCategories(), this.getNumFeatures(), (PriorFunction)new L1()).lambda(this.getLambda()).learningRate(this.getLearningRate()).alpha(0.999);
        }
        return this.lr;
    }

    public void saveTo(OutputStream out) throws IOException {
        Closeables.close((Closeable)this.lr, (boolean)false);
        this.targetCategories = this.getCsvRecordFactory().getTargetCategories();
        this.write(new DataOutputStream(out));
    }

    public static LogisticModelParameters loadFrom(InputStream in) throws IOException {
        LogisticModelParameters result = new LogisticModelParameters();
        result.readFields(new DataInputStream(in));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogisticModelParameters loadFrom(File in) throws IOException {
        FileInputStream input = new FileInputStream(in);
        try {
            LogisticModelParameters logisticModelParameters = LogisticModelParameters.loadFrom(input);
            return logisticModelParameters;
        }
        finally {
            Closeables.close((Closeable)input, (boolean)true);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.targetVariable);
        out.writeInt(this.typeMap.size());
        for (Map.Entry<String, String> entry : this.typeMap.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
        out.writeInt(this.numFeatures);
        out.writeBoolean(this.useBias);
        out.writeInt(this.maxTargetCategories);
        if (this.targetCategories == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.targetCategories.size());
            for (String category : this.targetCategories) {
                out.writeUTF(category);
            }
        }
        out.writeDouble(this.lambda);
        out.writeDouble(this.learningRate);
        this.lr.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.targetVariable = in.readUTF();
        int typeMapSize = in.readInt();
        this.typeMap = Maps.newHashMapWithExpectedSize((int)typeMapSize);
        for (int i = 0; i < typeMapSize; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.typeMap.put(key, value);
        }
        this.numFeatures = in.readInt();
        this.useBias = in.readBoolean();
        this.maxTargetCategories = in.readInt();
        int targetCategoriesSize = in.readInt();
        this.targetCategories = Lists.newArrayListWithCapacity((int)targetCategoriesSize);
        for (int i = 0; i < targetCategoriesSize; ++i) {
            this.targetCategories.add(in.readUTF());
        }
        this.lambda = in.readDouble();
        this.learningRate = in.readDouble();
        this.csv = null;
        this.lr = new OnlineLogisticRegression();
        this.lr.readFields(in);
    }

    public void setTypeMap(Iterable<String> predictorList, List<String> typeList) {
        Preconditions.checkArgument((!typeList.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one type specifier");
        this.typeMap = Maps.newHashMap();
        Iterator<String> iTypes = typeList.iterator();
        String lastType = null;
        for (String x : predictorList) {
            if (iTypes.hasNext()) {
                lastType = iTypes.next();
            }
            this.typeMap.put(x.toString(), lastType);
        }
    }

    public void setTargetVariable(String targetVariable) {
        this.targetVariable = targetVariable;
    }

    public void setMaxTargetCategories(int maxTargetCategories) {
        this.maxTargetCategories = maxTargetCategories;
    }

    public void setNumFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
    }

    public void setTargetCategories(List<String> targetCategories) {
        this.targetCategories = targetCategories;
        this.maxTargetCategories = targetCategories.size();
    }

    public List<String> getTargetCategories() {
        return this.targetCategories;
    }

    public void setUseBias(boolean useBias) {
        this.useBias = useBias;
    }

    public boolean useBias() {
        return this.useBias;
    }

    public String getTargetVariable() {
        return this.targetVariable;
    }

    public Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map<String, String> map) {
        this.typeMap = map;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public int getMaxTargetCategories() {
        return this.maxTargetCategories;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }
}

